/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;

public class GetFlushStateParam {
    private final String databaseName;
    private final String collectionName;
    private final List<Long> segmentIDs;
    private final Long flushTs;

    private GetFlushStateParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.segmentIDs = builder.segmentIDs;
        this.flushTs = builder.flushTs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<Long> getSegmentIDs() {
        return this.segmentIDs;
    }

    public Long getFlushTs() {
        return this.flushTs;
    }

    public String toString() {
        return "GetFlushStateParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", segmentIDs=" + this.segmentIDs + ", flushTs=" + this.flushTs + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private final List<Long> segmentIDs = new ArrayList<Long>();
        private Long flushTs = 0L;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Deprecated
        public Builder withSegmentIDs(List<Long> segmentIDs) {
            if (segmentIDs == null) {
                throw new IllegalArgumentException("segmentIDs cannot be null");
            }
            this.segmentIDs.addAll(segmentIDs);
            return this;
        }

        @Deprecated
        public Builder addSegmentID(Long segmentID) {
            if (segmentID == null) {
                throw new IllegalArgumentException("segmentID cannot be null");
            }
            this.segmentIDs.add(segmentID);
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFlushTs(Long flushTs) {
            if (flushTs == null) {
                throw new IllegalArgumentException("flushTs cannot be null");
            }
            this.flushTs = flushTs;
            return this;
        }

        public GetFlushStateParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetFlushStateParam(this);
        }
    }
}

