/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.credential;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class UpdateCredentialParam {
    private final String username;
    private final String oldPassword;
    private final String newPassword;

    private UpdateCredentialParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.username = builder.username;
        this.oldPassword = builder.oldPassword;
        this.newPassword = builder.newPassword;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String toString() {
        return "UpdateCredentialParam{username='" + this.username + '\'' + ", oldPassword='" + this.oldPassword + '\'' + ", newPassword='" + this.newPassword + '\'' + '}';
    }

    public static final class Builder {
        private String username;
        private String oldPassword;
        private String newPassword;

        private Builder() {
        }

        public Builder withUsername(String username) {
            if (username == null) {
                throw new IllegalArgumentException("username cannot be null");
            }
            this.username = username;
            return this;
        }

        public Builder withOldPassword(String password) {
            if (password == null) {
                throw new IllegalArgumentException("password cannot be null");
            }
            this.oldPassword = password;
            return this;
        }

        public Builder withNewPassword(String password) {
            if (password == null) {
                throw new IllegalArgumentException("password cannot be null");
            }
            this.newPassword = password;
            return this;
        }

        public UpdateCredentialParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.username, "Username");
            ParamUtils.CheckNullString(this.oldPassword, "OldPassword");
            ParamUtils.CheckNullEmptyString(this.newPassword, "NewPassword");
            return new UpdateCredentialParam(this);
        }
    }
}

