/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.InsertParam;
import java.util.List;

public class UpsertParam
extends InsertParam {
    private UpsertParam(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "UpsertParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", rowCount=" + this.rowCount + '}';
    }

    public static class Builder
    extends InsertParam.Builder {
        private Builder() {
        }

        @Override
        public Builder withDatabaseName(String databaseName) {
            super.withDatabaseName(databaseName);
            return this;
        }

        @Override
        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            super.withCollectionName(collectionName);
            return this;
        }

        @Override
        public Builder withPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            super.withPartitionName(partitionName);
            return this;
        }

        @Override
        public Builder withFields(List<InsertParam.Field> fields) {
            if (fields == null) {
                throw new IllegalArgumentException("fields cannot be null");
            }
            super.withFields(fields);
            return this;
        }

        @Override
        public Builder withRows(List<JsonObject> rows) {
            if (rows == null) {
                throw new IllegalArgumentException("rows cannot be null");
            }
            super.withRows(rows);
            return this;
        }

        @Override
        public UpsertParam build() throws ParamException {
            super.build();
            return new UpsertParam(this);
        }
    }
}

