/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class SelectUserParam {
    private final String userName;
    private final boolean includeRoleInfo;

    private SelectUserParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.userName = builder.userName;
        this.includeRoleInfo = builder.includeRoleInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isIncludeRoleInfo() {
        return this.includeRoleInfo;
    }

    public String toString() {
        return "SelectUserParam{userName='" + this.userName + '\'' + ", includeRoleInfo=" + this.includeRoleInfo + '}';
    }

    public static final class Builder {
        private String userName;
        private boolean includeRoleInfo;

        private Builder() {
        }

        public Builder withUserName(String userName) {
            if (userName == null) {
                throw new IllegalArgumentException("User name cannot be null");
            }
            this.userName = userName;
            return this;
        }

        public Builder withIncludeRoleInfo(boolean includeRoleInfo) {
            this.includeRoleInfo = includeRoleInfo;
            return this;
        }

        public SelectUserParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.userName, "UserName");
            return new SelectUserParam(this);
        }
    }
}

