/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.pool;

import io.milvus.pool.ClientCache;
import io.milvus.pool.PoolClientFactory;
import io.milvus.pool.PoolConfig;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPool<C, T> {
    protected static final Logger logger = LoggerFactory.getLogger(ClientPool.class);
    protected GenericKeyedObjectPool<String, T> clientPool;
    protected PoolConfig config;
    protected PoolClientFactory<C, T> clientFactory;
    private final ConcurrentMap<String, ClientCache<T>> clientsCache = new ConcurrentHashMap<String, ClientCache<T>>();
    private final Lock cacheMapLock = new ReentrantLock(true);

    protected ClientPool() {
    }

    protected ClientPool(PoolConfig config, PoolClientFactory<C, T> clientFactory) {
        this.config = config;
        this.clientFactory = clientFactory;
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(config.getMaxIdlePerKey());
        poolConfig.setMinIdlePerKey(config.getMinIdlePerKey());
        poolConfig.setMaxTotal(config.getMaxTotal());
        poolConfig.setMaxTotalPerKey(config.getMaxTotalPerKey());
        poolConfig.setBlockWhenExhausted(config.isBlockWhenExhausted());
        poolConfig.setMaxWait(config.getMaxBlockWaitDuration());
        poolConfig.setTestOnBorrow(config.isTestOnBorrow());
        poolConfig.setTestOnReturn(config.isTestOnReturn());
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTimeBetweenEvictionRuns(config.getEvictionPollingInterval());
        poolConfig.setNumTestsPerEvictionRun(5);
        poolConfig.setMinEvictableIdleTime(config.getMinEvictableIdleDuration());
        this.clientPool = new GenericKeyedObjectPool(clientFactory, poolConfig);
    }

    public void configForKey(String key, C config) {
        this.clientFactory.configForKey(key, config);
    }

    public void removeConfig(String key) {
        this.clientFactory.removeConfig(key);
    }

    public Set<String> configKeys() {
        return this.clientFactory.configKeys();
    }

    public C getConfig(String key) {
        return this.clientFactory.getConfig(key);
    }

    public void preparePool(String key) {
        ClientCache<T> cache = this.getCache(key);
        if (cache != null) {
            cache.preparePool();
        }
    }

    public T getClient(String key) {
        ClientCache<T> cache = this.getCache(key);
        if (cache == null) {
            logger.error("Not able to create a client cache for key: {}", (Object)key);
            return null;
        }
        return cache.getClient();
    }

    private ClientCache<T> getCache(String key) {
        ClientCache<T> cache = (ClientCache<T>)this.clientsCache.get(key);
        if (cache == null) {
            this.cacheMapLock.lock();
            try {
                if (!this.clientsCache.containsKey(key)) {
                    cache = new ClientCache<T>(key, this.clientPool);
                    this.clientsCache.put(key, cache);
                } else {
                    cache = (ClientCache)this.clientsCache.get(key);
                }
            }
            finally {
                this.cacheMapLock.unlock();
            }
        }
        return cache;
    }

    public void returnClient(String key, T grpcClient) {
        ClientCache cache = (ClientCache)this.clientsCache.get(key);
        if (cache != null) {
            cache.returnClient(grpcClient);
        } else {
            logger.warn("No such key: {}", (Object)key);
        }
    }

    public void close() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clear();
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    public void clear() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            for (ClientCache cache : this.clientsCache.values()) {
                cache.stopTimer();
            }
            this.clientsCache.clear();
            this.clientPool.clear();
        }
    }

    public void clear(String key) {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            ClientCache cache = (ClientCache)this.clientsCache.get(key);
            if (cache != null) {
                cache.stopTimer();
            }
            this.clientsCache.remove(key);
            this.clientPool.clear((Object)key);
        }
    }

    public int getIdleClientNumber(String key) {
        return this.clientPool.getNumIdle((Object)key);
    }

    public int getActiveClientNumber(String key) {
        return this.clientPool.getNumActive((Object)key);
    }

    public int getTotalIdleClientNumber() {
        return this.clientPool.getNumIdle();
    }

    public int getTotalActiveClientNumber() {
        return this.clientPool.getNumActive();
    }

    public float fetchClientPerSecond(String key) {
        ClientCache cache = (ClientCache)this.clientsCache.get(key);
        if (cache != null) {
            return cache.fetchClientPerSecond();
        }
        return 0.0f;
    }
}

