/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.IllegalResponseException;
import io.milvus.grpc.GetImportStateResponse;
import io.milvus.grpc.ImportState;
import io.milvus.grpc.KeyValuePair;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GetBulkInsertStateWrapper {
    private final GetImportStateResponse response;

    public GetBulkInsertStateWrapper(GetImportStateResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("GetImportStateResponse cannot be null");
        }
        this.response = response;
    }

    public long getTaskID() {
        return this.response.getId();
    }

    public List<Long> getAutoGeneratedIDs() {
        List<Long> ranges = this.response.getIdListList();
        if (ranges.size() % 2 != 0) {
            throw new IllegalResponseException("The bulk insert state response id range list is illegal");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < ranges.size() / 2; ++i) {
            Long begin = ranges.get(i * 2);
            Long end = ranges.get(i * 2 + 1);
            for (long j = begin.longValue(); j <= end; ++j) {
                ids.add(j);
            }
        }
        return ids;
    }

    public ImportState getState() {
        return this.response.getState();
    }

    public long getImportedCount() {
        return this.response.getRowCount();
    }

    public long getCreateTimestamp() {
        return this.response.getCreateTs();
    }

    public String getCreateTimeStr() {
        Timestamp ts = new Timestamp(this.response.getCreateTs());
        return ts.toString();
    }

    public String getFailedReason() {
        return this.getInfo("failed_reason");
    }

    public String getFiles() {
        return this.getInfo("files");
    }

    public String getCollectionName() {
        return this.getInfo("collection");
    }

    public String getPartitionName() {
        return this.getInfo("partition");
    }

    public int getProgress() {
        String value = this.getInfo("progress_percent");
        if (value.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    private String getInfo(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        List<KeyValuePair> infos = this.response.getInfosList();
        for (KeyValuePair kv : infos) {
            if (kv.getKey().compareTo(key) != 0) continue;
            return kv.getValue();
        }
        return "";
    }

    public String toString() {
        return "bulk insert task state{, collection:" + this.getCollectionName() + ", partition:" + this.getPartitionName() + ", autoGeneratedIDs:" + this.getAutoGeneratedIDs() + ", state:" + this.getState().name() + ", failed reason:" + this.getFailedReason() + ", files:" + this.getFiles() + ", progress:" + this.getProgress() + '}';
    }
}

