/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.common;

import java.util.Map;

public class IndexParam {
    private String fieldName;
    private String indexName;
    private IndexType indexType = IndexType.AUTOINDEX;
    private MetricType metricType;
    private Map<String, Object> extraParams;

    private IndexParam(IndexParamBuilder builder) {
        if (builder.fieldName == null) {
            throw new NullPointerException("fieldName cannot be null");
        }
        this.fieldName = builder.fieldName;
        this.indexName = builder.indexName;
        this.indexType = builder.indexType;
        this.metricType = builder.metricType;
        this.extraParams = builder.extraParams;
    }

    public static IndexParamBuilder builder() {
        return new IndexParamBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setFieldName(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName cannot be null");
        }
        this.fieldName = fieldName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }

    public String toString() {
        return "IndexParam{fieldName='" + this.fieldName + '\'' + ", indexName='" + this.indexName + '\'' + ", indexType=" + (Object)((Object)this.indexType) + ", metricType=" + (Object)((Object)this.metricType) + ", extraParams=" + this.extraParams + '}';
    }

    public static enum IndexType {
        None(0),
        FLAT(1),
        IVF_FLAT(2),
        IVF_SQ8(3),
        IVF_PQ(4),
        HNSW(5),
        HNSW_SQ(6),
        HNSW_PQ(7),
        HNSW_PRQ(8),
        DISKANN(10),
        AUTOINDEX(11),
        SCANN(12),
        IVF_RABITQ(13),
        GPU_IVF_FLAT(50),
        GPU_IVF_PQ(51),
        GPU_BRUTE_FORCE(52),
        GPU_CAGRA(53),
        BIN_FLAT(80),
        BIN_IVF_FLAT(81),
        MINHASH_LSH(82),
        TRIE("Trie", 100),
        NGRAM(101),
        RTREE(120),
        STL_SORT(200),
        INVERTED(201),
        BITMAP(202),
        SPARSE_INVERTED_INDEX(300),
        SPARSE_WAND(301);

        private final String name;
        private final int code;

        private IndexType() {
            this.name = this.toString();
            this.code = this.ordinal();
        }

        private IndexType(int code) {
            this.name = this.toString();
            this.code = code;
        }

        private IndexType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum MetricType {
        INVALID,
        L2,
        IP,
        COSINE,
        HAMMING,
        JACCARD,
        MHJACCARD,
        BM25,
        MAX_SIM,
        MAX_SIM_COSINE,
        MAX_SIM_IP,
        MAX_SIM_L2,
        MAX_SIM_JACCARD,
        MAX_SIM_HAMMING;

    }

    public static class IndexParamBuilder {
        private String fieldName;
        private String indexName;
        private IndexType indexType = IndexType.AUTOINDEX;
        private MetricType metricType;
        private Map<String, Object> extraParams;

        public IndexParamBuilder fieldName(String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName cannot be null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public IndexParamBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public IndexParamBuilder indexType(IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public IndexParamBuilder metricType(MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public IndexParamBuilder extraParams(Map<String, Object> extraParams) {
            this.extraParams = extraParams;
            return this;
        }

        public IndexParam build() {
            return new IndexParam(this);
        }
    }
}

