/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.stub.MetadataUtils;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.GetVersionRequest;
import io.milvus.grpc.GetVersionResponse;
import io.milvus.grpc.ListDatabasesRequest;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.utils.RpcUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    Logger logger = LoggerFactory.getLogger(ClientUtils.class);
    RpcUtils rpcUtils = new RpcUtils();

    public ManagedChannel getChannel(final ConnectConfig connectConfig) {
        ManagedChannel channel = null;
        Metadata metadata = new Metadata();
        if (connectConfig.getAuthorization() != null) {
            metadata.put(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)Base64.getEncoder().encodeToString(connectConfig.getAuthorization().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotEmpty((CharSequence)connectConfig.getDbName())) {
            metadata.put(Metadata.Key.of((String)"dbname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)connectConfig.getDbName());
        }
        ArrayList<ClientInterceptor> clientInterceptors = new ArrayList<ClientInterceptor>();
        clientInterceptors.add(MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata));
        clientInterceptors.add(new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        String clientID;
                        String currentMs = String.valueOf(System.currentTimeMillis());
                        headers.put(Metadata.Key.of((String)"client-request-unixmsec", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)currentMs);
                        if (connectConfig.getClientRequestId() != null && !StringUtils.isEmpty((CharSequence)(clientID = connectConfig.getClientRequestId().get()))) {
                            headers.put(Metadata.Key.of((String)"client_request_id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)clientID);
                        }
                        super.start(responseListener, headers);
                    }
                };
            }
        });
        try {
            if (connectConfig.getSslContext() != null) {
                NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).overrideAuthority(connectConfig.getServerName())).sslContext((SslContext)ClientUtils.convertJavaSslContextToNetty(connectConfig)).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(clientInterceptors);
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getProxyAddress())) {
                    ClientUtils.configureProxy((ManagedChannelBuilder)builder, connectConfig.getProxyAddress());
                }
                if (connectConfig.isSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getServerName())) {
                    builder.overrideAuthority(connectConfig.getServerName());
                }
                channel = builder.build();
            } else if (StringUtils.isNotEmpty((CharSequence)connectConfig.getServerPemPath())) {
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(connectConfig.getServerPemPath())).build();
                NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).overrideAuthority(connectConfig.getServerName())).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(clientInterceptors);
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getProxyAddress())) {
                    ClientUtils.configureProxy((ManagedChannelBuilder)builder, connectConfig.getProxyAddress());
                }
                if (connectConfig.isSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                channel = builder.build();
            } else if (StringUtils.isNotEmpty((CharSequence)connectConfig.getClientPemPath()) && StringUtils.isNotEmpty((CharSequence)connectConfig.getClientKeyPath()) && StringUtils.isNotEmpty((CharSequence)connectConfig.getCaPemPath())) {
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(connectConfig.getCaPemPath())).keyManager(new File(connectConfig.getClientPemPath()), new File(connectConfig.getClientKeyPath())).build();
                NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(clientInterceptors);
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getProxyAddress())) {
                    ClientUtils.configureProxy((ManagedChannelBuilder)builder, connectConfig.getProxyAddress());
                }
                if (connectConfig.getSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getServerName())) {
                    builder.overrideAuthority(connectConfig.getServerName());
                }
                channel = builder.build();
            } else {
                ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).intercept(clientInterceptors);
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getProxyAddress())) {
                    ClientUtils.configureProxy(builder, connectConfig.getProxyAddress());
                }
                if (connectConfig.isSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                channel = builder.build();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to open credentials file, error:{}\n", (Object)e.getMessage());
        }
        assert (channel != null);
        return channel;
    }

    public static void configureProxy(ManagedChannelBuilder builder, String proxyAddress) {
        String[] hostPort = proxyAddress.split(":");
        if (hostPort.length == 2) {
            final String proxyHost = hostPort[0];
            final int proxyPort = Integer.parseInt(hostPort[1]);
            builder.proxyDetector(new ProxyDetector(){

                public ProxiedSocketAddress proxyFor(SocketAddress targetServerAddress) {
                    return HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress((SocketAddress)new InetSocketAddress(proxyHost, proxyPort)).setTargetAddress((InetSocketAddress)targetServerAddress).build();
                }
            });
        }
    }

    private static JdkSslContext convertJavaSslContextToNetty(ConnectConfig connectConfig) {
        ApplicationProtocolConfig applicationProtocolConfig = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NONE, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[0]);
        return new JdkSslContext(connectConfig.getSslContext(), true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, applicationProtocolConfig, ClientAuth.NONE, null, false);
    }

    public void checkDatabaseExist(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String dbName) {
        String title = String.format("Check database %s exist", dbName);
        ListDatabasesRequest listDatabasesRequest = ListDatabasesRequest.newBuilder().build();
        ListDatabasesResponse response = blockingStub.listDatabases(listDatabasesRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        if (!response.getDbNamesList().contains((Object)dbName)) {
            throw new IllegalArgumentException("Database " + dbName + " not exist");
        }
    }

    public String getServerVersion(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        GetVersionResponse response = blockingStub.getVersion(GetVersionRequest.newBuilder().build());
        this.rpcUtils.handleResponse("Get server version", response.getStatus());
        return response.getVersion();
    }

    public String getHostName() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("Failed to get host name, error:{}\n", (Object)e.getMessage());
            return "Unknown";
        }
    }

    public String getLocalTimeStr() {
        LocalDateTime now = LocalDateTime.now();
        return now.toString();
    }

    public String getSDKVersion() {
        Package pkg = MilvusServiceClient.class.getPackage();
        String ver = pkg.getImplementationVersion();
        if (ver == null) {
            return "";
        }
        return ver;
    }

    public void validateHostname(ConnectConfig connectConfig) {
        String host = connectConfig.getHost();
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Hostname cannot be null or empty");
        }
        try {
            InetAddress.getByName(host);
            this.logger.debug("Successfully resolved hostname: {}", (Object)host);
        }
        catch (UnknownHostException e) {
            String message = String.format("Failed to resolve hostname '%s'. Please verify the hostname is correct and DNS is configured properly.", host);
            this.logger.error(message, (Throwable)e);
            throw new MilvusClientException(ErrorCode.RPC_ERROR, message);
        }
    }

    public void validatePort(ConnectConfig connectConfig) {
        int port = connectConfig.getPort();
        String host = connectConfig.getHost();
        if (port < 1 || port > 65535) {
            String message = String.format("Invalid port number '%d'. Port must be between 1 and 65535.", port);
            this.logger.error(message);
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, message);
        }
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), (int)connectConfig.getConnectTimeoutMs());
            this.logger.debug("Successfully validated port: {}", (Object)port);
        }
        catch (IOException e) {
            String message = String.format("Cannot connect to '%s:%d'. Please verify the port number is correct and server is running.", host, port);
            this.logger.error(message, (Throwable)e);
            throw new MilvusClientException(ErrorCode.RPC_ERROR, message);
        }
    }

    public void validateCert(ConnectConfig connectConfig) {
        if (!connectConfig.isSecure().booleanValue()) {
            return;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = null;
            if (connectConfig.getServerPemPath() != null && !connectConfig.getServerPemPath().isEmpty()) {
                try (FileInputStream certStream = new FileInputStream(connectConfig.getServerPemPath());){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate caCert = (X509Certificate)cf.generateCertificate(certStream);
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                    trustStore.setCertificateEntry("ca-cert", caCert);
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trustStore);
                }
            }
            sslContext.init(null, tmf != null ? tmf.getTrustManagers() : null, new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            try (SSLSocket socket = (SSLSocket)socketFactory.createSocket();){
                socket.connect(new InetSocketAddress(connectConfig.getHost(), connectConfig.getPort()), (int)connectConfig.getConnectTimeoutMs());
                socket.startHandshake();
                this.logger.debug("SSL certificate validation passed");
            }
        }
        catch (SSLException e) {
            throw new MilvusClientException(ErrorCode.RPC_ERROR, "SSL certificate validation failed: " + e.getMessage() + ". Please verify your certificates are correct.");
        }
        catch (Exception e) {
            throw new MilvusClientException(ErrorCode.RPC_ERROR, "Failed to connect with SSL: " + e.getMessage());
        }
    }
}

