/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FloatArray;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.StructArrayField;
import io.milvus.grpc.UpsertRequest;
import io.milvus.grpc.VectorArray;
import io.milvus.grpc.VectorField;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.utils.ConvertUtils;
import io.milvus.v2.utils.VectorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataUtils {
    private static FieldData genStructSubFieldData(CreateCollectionReq.FieldSchema fieldSchema, List<?> objects) {
        if (objects == null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Cannot generate FieldData from null object");
        }
        io.milvus.grpc.DataType dataType = ConvertUtils.toProtoDataType(fieldSchema.getDataType());
        String fieldName = fieldSchema.getName();
        FieldData.Builder builder = FieldData.newBuilder().setFieldName(fieldName);
        if (ParamUtils.isVectorDataType(dataType)) {
            VectorArray vectorArr = DataUtils.genVectorArray(dataType, objects, fieldSchema.getDimension());
            if (vectorArr.getDim() > 0L && vectorArr.getDim() != (long)fieldSchema.getDimension().intValue()) {
                String msg = String.format("Dimension mismatch for field %s, expected: %d, actual: %d", fieldName, fieldSchema.getDimension(), vectorArr.getDim());
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
            return builder.setType(io.milvus.grpc.DataType.ArrayOfVector).setVectors(VectorField.newBuilder().setVectorArray(vectorArr).setDim(fieldSchema.getDimension().intValue()).build()).build();
        }
        if (fieldSchema.getIsNullable().booleanValue() || fieldSchema.getDefaultValue() != null) {
            ArrayList tempObjects = new ArrayList();
            for (Object obj : objects) {
                builder.addValidData(obj != null);
                if (obj == null) continue;
                tempObjects.add(obj);
            }
            objects = tempObjects;
        }
        ScalarField scalarField = ParamUtils.genScalarField(io.milvus.grpc.DataType.Array, dataType, objects);
        return builder.setType(io.milvus.grpc.DataType.Array).setScalars(scalarField).build();
    }

    public static VectorArray genVectorArray(io.milvus.grpc.DataType dataType, List<?> objects, int dim) {
        VectorArray.Builder builder = VectorArray.newBuilder().setElementType(dataType).setDim(dim);
        switch (dataType) {
            case FloatVector: 
            case BinaryVector: 
            case Float16Vector: 
            case BFloat16Vector: 
            case Int8Vector: {
                for (Object object : objects) {
                    if (!(object instanceof List)) {
                        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Input value is not List<> for type: " + dataType.name());
                    }
                    List listOfList = (List)object;
                    if (listOfList.isEmpty()) {
                        VectorField.Builder vfBuilder = VectorField.newBuilder().setDim(dim);
                        if (dataType != io.milvus.grpc.DataType.FloatVector) {
                            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Unsupported type: " + dataType.name());
                        }
                        vfBuilder.setFloatVector(FloatArray.newBuilder().build());
                        builder.addData(vfBuilder.build());
                        continue;
                    }
                    VectorField vf = ParamUtils.genVectorField(dataType, listOfList);
                    if (vf.getDim() != (long)dim) {
                        String msg = String.format("Dimension mismatch for vector field, schema dimension: %d, actual dimension: %d", dim, vf.getDim());
                        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                    }
                    builder.addData(vf);
                }
                return builder.build();
            }
        }
        String msg = String.format("Illegal vector dataType %s for struct field", dataType.name());
        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
    }

    public DeleteRequest ConvertToGrpcDeleteRequest(DeleteReq request) {
        String dbName;
        DeleteRequest.Builder builder = DeleteRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).setExpr(request.getFilter());
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            Map<String, Object> filterTemplateValues = request.getFilterTemplateValues();
            filterTemplateValues.forEach((key, value) -> builder.putExprTemplateValues((String)key, VectorUtils.deduceAndCreateTemplateValue(value)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(dbName = request.getDatabaseName()))) {
            builder.setDbName(dbName);
        }
        return builder.build();
    }

    private static FieldData genFieldData(CreateCollectionReq.FieldSchema field, List<?> objects, boolean isDynamic) {
        String fieldName = field.getName();
        io.milvus.grpc.DataType dataType = ConvertUtils.toProtoDataType(field.getDataType());
        io.milvus.grpc.DataType elementType = ConvertUtils.toProtoDataType(field.getElementType());
        boolean isNullable = field.getIsNullable();
        Object defaultVal = field.getDefaultValue();
        return ParamUtils.genFieldData(fieldName, dataType, elementType, isNullable, defaultVal, objects, isDynamic);
    }

    public static Object checkFieldValue(CreateCollectionReq.FieldSchema field, JsonElement fieldData) {
        io.milvus.grpc.DataType dataType = ConvertUtils.toProtoDataType(field.getDataType());
        io.milvus.grpc.DataType elementType = ConvertUtils.toProtoDataType(field.getElementType());
        int dim = field.getDimension() == null ? 0 : field.getDimension();
        int maxLength = field.getMaxLength() == null ? 0 : field.getMaxLength();
        int maxCapacity = field.getMaxCapacity() == null ? 0 : field.getMaxCapacity();
        return ParamUtils.checkFieldValue(field.getName(), dataType, elementType, dim, maxLength, maxCapacity, field.getIsNullable(), field.getDefaultValue(), fieldData);
    }

    public static class InsertDataInfo {
        public CreateCollectionReq.FieldSchema field;
        public LinkedList<Object> data;

        public InsertDataInfo(CreateCollectionReq.FieldSchema field, LinkedList<Object> data) {
            this.field = field;
            this.data = data;
        }
    }

    public static class InsertBuilderWrapper {
        private InsertRequest.Builder insertBuilder;
        private UpsertRequest.Builder upsertBuilder;

        public InsertRequest convertGrpcInsertRequest(InsertReq requestParam, DescribeCollectionResp descColl) {
            String dbName = requestParam.getDatabaseName();
            String collectionName = requestParam.getCollectionName();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
            this.insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getData().size());
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                this.insertBuilder.setDbName(dbName);
            }
            this.upsertBuilder = null;
            this.fillFieldsData(requestParam, descColl);
            return this.insertBuilder.build();
        }

        public UpsertRequest convertGrpcUpsertRequest(UpsertReq requestParam, DescribeCollectionResp descColl) {
            String dbName = requestParam.getDatabaseName();
            String collectionName = requestParam.getCollectionName();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Upsert).build();
            this.upsertBuilder = UpsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setPartialUpdate(requestParam.isPartialUpdate()).setNumRows(requestParam.getData().size());
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                this.upsertBuilder.setDbName(dbName);
            }
            this.insertBuilder = null;
            this.fillFieldsData(requestParam, descColl);
            return this.upsertBuilder.build();
        }

        private void addFieldsData(FieldData value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.addFieldsData(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.addFieldsData(value);
            }
        }

        private void setPartitionName(String value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.setPartitionName(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.setPartitionName(value);
            }
        }

        private static boolean hasPartitionKey(DescribeCollectionResp descColl) {
            CreateCollectionReq.CollectionSchema collectionSchema = descColl.getCollectionSchema();
            List<CreateCollectionReq.FieldSchema> fieldsList = collectionSchema.getFieldSchemaList();
            for (CreateCollectionReq.FieldSchema field : fieldsList) {
                if (field.getIsPartitionKey() != Boolean.TRUE) continue;
                return true;
            }
            return false;
        }

        private void fillFieldsData(UpsertReq requestParam, DescribeCollectionResp descColl) {
            String partitionName = requestParam.getPartitionName();
            if (InsertBuilderWrapper.hasPartitionKey(descColl)) {
                if (partitionName != null && !partitionName.isEmpty()) {
                    String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                }
            } else if (partitionName != null) {
                this.setPartitionName(partitionName);
            }
            List<JsonObject> rowFields = requestParam.getData();
            this.checkAndSetRowData(descColl, rowFields, requestParam.isPartialUpdate());
        }

        private void fillFieldsData(InsertReq requestParam, DescribeCollectionResp descColl) {
            String partitionName = requestParam.getPartitionName();
            if (InsertBuilderWrapper.hasPartitionKey(descColl)) {
                if (partitionName != null && !partitionName.isEmpty()) {
                    String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                }
            } else if (partitionName != null) {
                this.setPartitionName(partitionName);
            }
            List<JsonObject> rowFields = requestParam.getData();
            this.checkAndSetRowData(descColl, rowFields, false);
        }

        private static String combineStructFieldName(String structName, String subFieldName) {
            return String.format("%s[%s]", structName, subFieldName);
        }

        private void checkAndSetRowData(DescribeCollectionResp descColl, List<JsonObject> rows, boolean partialUpdate) {
            CreateCollectionReq.CollectionSchema collectionSchema = descColl.getCollectionSchema();
            List<CreateCollectionReq.Function> functionsList = collectionSchema.getFunctionList();
            ArrayList<String> outputFieldNames = new ArrayList<String>();
            for (CreateCollectionReq.Function function : functionsList) {
                outputFieldNames.addAll(function.getOutputFieldNames());
            }
            List<CreateCollectionReq.FieldSchema> normalFields = collectionSchema.getFieldSchemaList();
            List<CreateCollectionReq.StructFieldSchema> structFields = collectionSchema.getStructFields();
            ArrayList allFieldNames = new ArrayList();
            normalFields.forEach(schema -> allFieldNames.add(schema.getName()));
            structFields.forEach(schema -> allFieldNames.add(schema.getName()));
            HashMap<String, InsertDataInfo> normalInsertData = new HashMap<String, InsertDataInfo>();
            HashMap<String, InsertDataInfo> structInsertData = new HashMap<String, InsertDataInfo>();
            InsertDataInfo insertDynamicDataInfo = new InsertDataInfo(CreateCollectionReq.FieldSchema.builder().name("$meta").dataType(DataType.JSON).build(), new LinkedList<Object>());
            for (JsonObject row : rows) {
                for (CreateCollectionReq.FieldSchema fieldSchema : normalFields) {
                    this.processNormalFieldValues(row, fieldSchema, outputFieldNames, normalInsertData, partialUpdate);
                }
                for (CreateCollectionReq.StructFieldSchema structFieldSchema : structFields) {
                    this.processStructFieldValues(row, structFieldSchema, structInsertData);
                }
                if (!collectionSchema.isEnableDynamicField()) continue;
                JsonObject dynamicField = new JsonObject();
                for (String rowFieldName : row.keySet()) {
                    if (allFieldNames.contains(rowFieldName)) continue;
                    dynamicField.add(rowFieldName, row.get(rowFieldName));
                }
                insertDynamicDataInfo.data.add(dynamicField);
            }
            for (String fieldNameKey : normalInsertData.keySet()) {
                InsertDataInfo insertDataInfo = (InsertDataInfo)normalInsertData.get(fieldNameKey);
                this.addFieldsData(DataUtils.genFieldData(insertDataInfo.field, insertDataInfo.data, false));
            }
            for (CreateCollectionReq.StructFieldSchema structField : structFields) {
                StructArrayField.Builder structBuilder = StructArrayField.newBuilder();
                for (CreateCollectionReq.FieldSchema field : structField.getFields()) {
                    String combineName = InsertBuilderWrapper.combineStructFieldName(structField.getName(), field.getName());
                    InsertDataInfo insertDataInfo = (InsertDataInfo)structInsertData.get(combineName);
                    FieldData grpcField = DataUtils.genStructSubFieldData(field, insertDataInfo.data);
                    structBuilder.addFields(grpcField);
                }
                FieldData.Builder builder = FieldData.newBuilder();
                this.addFieldsData(builder.setFieldName(structField.getName()).setType(io.milvus.grpc.DataType.ArrayOfStruct).setStructArrays(structBuilder.build()).build());
            }
            if (collectionSchema.isEnableDynamicField()) {
                this.addFieldsData(DataUtils.genFieldData(insertDynamicDataInfo.field, insertDynamicDataInfo.data, true));
            }
        }

        private void processNormalFieldValues(JsonObject row, CreateCollectionReq.FieldSchema field, List<String> outputFieldNames, Map<String, InsertDataInfo> nameInsertInfo, boolean partialUpdate) {
            String fieldName = field.getName();
            InsertDataInfo insertDataInfo = nameInsertInfo.getOrDefault(fieldName, new InsertDataInfo(field, new LinkedList<Object>()));
            JsonElement fieldData = row.get(fieldName);
            if (fieldData == null) {
                if (field.getAutoID() == Boolean.TRUE) {
                    return;
                }
                if (outputFieldNames.contains(fieldName)) {
                    return;
                }
                if (partialUpdate) {
                    return;
                }
                if (!field.getIsNullable().booleanValue() && field.getDefaultValue() == null) {
                    String msg = String.format("The field: %s is not provided.", fieldName);
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                }
                fieldData = JsonNull.INSTANCE;
            }
            Object fieldValue = DataUtils.checkFieldValue(field, fieldData);
            insertDataInfo.data.add(fieldValue);
            nameInsertInfo.put(fieldName, insertDataInfo);
        }

        private void processStructFieldValues(JsonObject row, CreateCollectionReq.StructFieldSchema structField, Map<String, InsertDataInfo> nameInsertInfo) {
            String structName = structField.getName();
            JsonElement rowFieldData = row.get(structName);
            if (rowFieldData == null) {
                String msg = String.format("The struct field: %s is not provided.", structName);
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
            if (!rowFieldData.isJsonArray()) {
                String msg = String.format("The value of struct field: %s is not a JSON array.", structName);
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
            for (CreateCollectionReq.FieldSchema field : structField.getFields()) {
                String combineName = InsertBuilderWrapper.combineStructFieldName(structName, field.getName());
                InsertDataInfo insertDataInfo = nameInsertInfo.getOrDefault(combineName, new InsertDataInfo(field, new LinkedList<Object>()));
                nameInsertInfo.put(combineName, insertDataInfo);
            }
            JsonArray structs = rowFieldData.getAsJsonArray();
            for (CreateCollectionReq.FieldSchema field : structField.getFields()) {
                String subFieldName = field.getName();
                InsertDataInfo insertDataInfo = nameInsertInfo.get(InsertBuilderWrapper.combineStructFieldName(structName, subFieldName));
                ArrayList columnData = new ArrayList();
                structs.forEach(element -> {
                    if (!element.isJsonObject()) {
                        String msg = String.format("The element of struct field: %s is not a JSON dict.", structName);
                        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                    }
                    JsonObject struct = element.getAsJsonObject();
                    JsonElement fieldData = struct.get(subFieldName);
                    if (fieldData == null) {
                        String msg = String.format("The %s of struct field: %s is not provided.", subFieldName, structName);
                        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                    }
                    Object fieldValue = DataUtils.checkFieldValue(field, fieldData);
                    columnData.add(fieldValue);
                });
                insertDataInfo.data.add(columnData);
            }
        }
    }
}

