/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.orm.iterator;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.grpc.PlaceholderType;
import io.milvus.param.MetricType;
import io.milvus.param.collection.FieldType;
import io.milvus.param.dml.QueryIteratorParam;
import io.milvus.param.dml.SearchIteratorParam;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.data.BFloat16Vec;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.data.BinaryVec;
import io.milvus.v2.service.vector.request.data.Float16Vec;
import io.milvus.v2.service.vector.request.data.FloatVec;
import io.milvus.v2.service.vector.request.data.SparseFloatVec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

public class IteratorAdapterV2 {
    public static QueryIteratorParam convertV2Req(QueryIteratorReq queryIteratorReq) {
        QueryIteratorParam.Builder builder = QueryIteratorParam.newBuilder().withDatabaseName(queryIteratorReq.getDatabaseName()).withCollectionName(queryIteratorReq.getCollectionName()).withPartitionNames(queryIteratorReq.getPartitionNames()).withExpr(queryIteratorReq.getExpr()).withOutFields(queryIteratorReq.getOutputFields()).withOffset(queryIteratorReq.getOffset()).withLimit(queryIteratorReq.getLimit()).withIgnoreGrowing(queryIteratorReq.isIgnoreGrowing()).withBatchSize(queryIteratorReq.getBatchSize()).withReduceStopForBest(queryIteratorReq.isReduceStopForBest());
        if (queryIteratorReq.getConsistencyLevel() != null) {
            builder.withConsistencyLevel(ConsistencyLevelEnum.valueOf(queryIteratorReq.getConsistencyLevel().name()));
        }
        return builder.build();
    }

    public static QueryIteratorReq convertV1Param(QueryIteratorParam param) {
        ConsistencyLevel level = null;
        if (param.getConsistencyLevel() != null) {
            level = ConsistencyLevel.valueOf(param.getConsistencyLevel().name());
        }
        return QueryIteratorReq.builder().databaseName(param.getDatabaseName()).collectionName(param.getCollectionName()).partitionNames(param.getPartitionNames()).expr(param.getExpr()).outputFields(param.getOutFields()).offset(param.getOffset()).limit(param.getLimit()).ignoreGrowing(param.isIgnoreGrowing()).batchSize(param.getBatchSize()).reduceStopForBest(param.isReduceStopForBest()).consistencyLevel(level).build();
    }

    public static SearchIteratorParam convertV2Req(SearchIteratorReq searchIteratorReq) {
        MetricType metricType = MetricType.None;
        if (searchIteratorReq.getMetricType() != IndexParam.MetricType.INVALID) {
            metricType = MetricType.valueOf(searchIteratorReq.getMetricType().name());
        }
        SearchIteratorParam.Builder builder = SearchIteratorParam.newBuilder().withDatabaseName(searchIteratorReq.getDatabaseName()).withCollectionName(searchIteratorReq.getCollectionName()).withPartitionNames(searchIteratorReq.getPartitionNames()).withVectorFieldName(searchIteratorReq.getVectorFieldName()).withMetricType(metricType).withLimit(searchIteratorReq.getLimit()).withExpr(searchIteratorReq.getExpr()).withOutFields(searchIteratorReq.getOutputFields()).withRoundDecimal(searchIteratorReq.getRoundDecimal()).withParams(searchIteratorReq.getParams()).withGroupByFieldName(searchIteratorReq.getGroupByFieldName()).withIgnoreGrowing(searchIteratorReq.isIgnoreGrowing()).withBatchSize(searchIteratorReq.getBatchSize());
        if (searchIteratorReq.getConsistencyLevel() != null) {
            builder.withConsistencyLevel(ConsistencyLevelEnum.valueOf(searchIteratorReq.getConsistencyLevel().name()));
        }
        List<BaseVector> vectors = searchIteratorReq.getVectors();
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        for (BaseVector vector2 : vectors) {
            if (vector2.getPlaceholderType() == plType) continue;
            throw new ParamException("Different types of target vectors in a search request is not allowed.");
        }
        switch (plType) {
            case FloatVector: {
                ArrayList<List<Float>> data = new ArrayList<List<Float>>();
                vectors.forEach(vector -> data.add((List)vector.getData()));
                builder.withFloatVectors(data);
                break;
            }
            case BinaryVector: {
                ArrayList<List<Float>> data = new ArrayList();
                vectors.forEach(vector -> data.add((List<Float>)((Object)((ByteBuffer)vector.getData()))));
                builder.withBinaryVectors(data);
                break;
            }
            case Float16Vector: {
                ArrayList<List<Float>> data = new ArrayList();
                vectors.forEach(vector -> data.add((List<Float>)((Object)((ByteBuffer)vector.getData()))));
                builder.withFloat16Vectors(data);
                break;
            }
            case BFloat16Vector: {
                ArrayList<List<Float>> data = new ArrayList();
                vectors.forEach(vector -> data.add((List<Float>)((Object)((ByteBuffer)vector.getData()))));
                builder.withBFloat16Vectors(data);
                break;
            }
            case SparseFloatVector: {
                ArrayList<List<Float>> data = new ArrayList();
                vectors.forEach(vector -> data.add((List<Float>)((Object)((SortedMap)vector.getData()))));
                builder.withSparseFloatVectors(data);
                break;
            }
            default: {
                throw new ParamException("Unsupported vector type.");
            }
        }
        return builder.build();
    }

    public static SearchIteratorReq convertV1Param(SearchIteratorParam param) {
        ConsistencyLevel level = null;
        if (param.getConsistencyLevel() != null) {
            level = ConsistencyLevel.valueOf(param.getConsistencyLevel().name());
        }
        IndexParam.MetricType metricType = IndexParam.MetricType.INVALID;
        if (StringUtils.isEmpty((CharSequence)param.getMetricType())) {
            metricType = IndexParam.MetricType.valueOf(param.getMetricType());
        }
        ArrayList<BaseVector> vectors = new ArrayList<BaseVector>();
        switch (param.getPlType()) {
            case FloatVector: {
                List<?> data = param.getVectors();
                data.forEach(vector -> vectors.add(new FloatVec((List<Float>)vector)));
                break;
            }
            case BinaryVector: {
                List<?> data = param.getVectors();
                data.forEach(vector -> vectors.add(new BinaryVec((ByteBuffer)vector)));
                break;
            }
            case Float16Vector: {
                List<?> data = param.getVectors();
                data.forEach(vector -> vectors.add(new Float16Vec((ByteBuffer)vector)));
                break;
            }
            case BFloat16Vector: {
                List<?> data = param.getVectors();
                data.forEach(vector -> vectors.add(new BFloat16Vec((ByteBuffer)vector)));
                break;
            }
            case SparseFloatVector: {
                List<?> data = param.getVectors();
                data.forEach(vector -> vectors.add(new SparseFloatVec((SortedMap<Long, Float>)vector)));
                break;
            }
            default: {
                throw new ParamException("Unsupported vector type.");
            }
        }
        return SearchIteratorReq.builder().databaseName(param.getDatabaseName()).collectionName(param.getCollectionName()).partitionNames(param.getPartitionNames()).vectorFieldName(param.getVectorFieldName()).vectors(vectors).consistencyLevel(level).metricType(metricType).limit(param.getTopK()).expr(param.getExpr()).outputFields(param.getOutFields()).roundDecimal(param.getRoundDecimal()).params(param.getParams()).groupByFieldName(param.getGroupByFieldName()).ignoreGrowing(param.isIgnoreGrowing()).batchSize(param.getBatchSize()).build();
    }

    public static FieldType convertV2Field(CreateCollectionReq.FieldSchema schema) {
        FieldType.Builder builder = FieldType.newBuilder().withName(schema.getName()).withDataType(DataType.valueOf(schema.getDataType().name())).withPrimaryKey(schema.getIsPrimaryKey()).withAutoID(schema.getAutoID()).withPartitionKey(schema.getIsPartitionKey());
        if (schema.getDimension() != null) {
            builder.withDimension(schema.getDimension());
        }
        if (schema.getMaxLength() != null) {
            builder.withMaxLength(schema.getMaxLength());
        }
        if (schema.getMaxCapacity() != null) {
            builder.withMaxCapacity(schema.getMaxLength());
        }
        if (schema.getElementType() != null) {
            builder.withElementType(DataType.valueOf(schema.getElementType().name()));
        }
        return builder.build();
    }
}

