/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.bulkinsert;

import io.milvus.exception.ParamException;

public class ListBulkInsertTasksParam {
    private final String databaseName;
    private final String collectionName;
    private final int limit;

    private ListBulkInsertTasksParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.limit = builder.limit;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        return "ListBulkInsertTasksParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", limit=" + this.limit + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName = "";
        private Integer limit = 0;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withLimit(Integer limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.limit = limit;
            if (this.limit < 0) {
                this.limit = 0;
            }
            return this;
        }

        public ListBulkInsertTasksParam build() throws ParamException {
            return new ListBulkInsertTasksParam(this);
        }
    }
}

