/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;

public class AlterCollectionParam {
    private final String collectionName;
    private final String databaseName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterCollectionParam(Builder builder) {
        if (builder.collectionName == null) {
            throw new IllegalArgumentException("collectionName cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.properties.putAll(builder.properties);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "AlterCollectionParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", properties=" + this.properties + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withTTL(Integer ttlSeconds) {
            if (ttlSeconds == null) {
                throw new IllegalArgumentException("ttlSeconds cannot be null");
            }
            if (ttlSeconds < 0) {
                throw new ParamException("The ttlSeconds value should be 0 or greater");
            }
            return this.withProperty("collection.ttl.seconds", Integer.toString(ttlSeconds));
        }

        public Builder withMMapEnabled(boolean enabledMMap) {
            return this.withProperty("mmap.enabled", Boolean.toString(enabledMMap));
        }

        public Builder withProperty(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.properties.put(key, value);
            return this;
        }

        public AlterCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new AlterCollectionParam(this);
        }
    }
}

