/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlterDatabaseParam {
    private final String databaseName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterDatabaseParam(Builder builder) {
        if (builder.databaseName == null) {
            throw new IllegalArgumentException("databaseName cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.properties.putAll(builder.properties);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "AlterDatabaseParam{databaseName='" + this.databaseName + '\'' + ", properties=" + this.properties + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            if (databaseName == null) {
                throw new IllegalArgumentException("databaseName cannot be null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public Builder withReplicaNumber(int replicaNumber) {
            return this.withProperty("database.replica.number", Integer.toString(replicaNumber));
        }

        public Builder withResourceGroups(List<String> resourceGroups) {
            if (resourceGroups == null) {
                throw new IllegalArgumentException("resourceGroups cannot be null");
            }
            return this.withProperty("database.resource_groups", String.join((CharSequence)",", resourceGroups));
        }

        public Builder withProperty(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.properties.put(key, value);
            return this;
        }

        public AlterDatabaseParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.databaseName, "Database name");
            return new AlterDatabaseParam(this);
        }
    }
}

