/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.credential;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DeleteCredentialParam {
    private final String username;

    private DeleteCredentialParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.username = builder.username;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "DeleteCredentialParam{username='" + this.username + '\'' + '}';
    }

    public static final class Builder {
        private String username;

        private Builder() {
        }

        public Builder withUsername(String username) {
            if (username == null) {
                throw new IllegalArgumentException("username cannot be null");
            }
            this.username = username;
            return this;
        }

        public DeleteCredentialParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.username, "Username");
            return new DeleteCredentialParam(this);
        }
    }
}

