/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DeleteParam {
    protected final String databaseName;
    private final String collectionName;
    private final String partitionName;
    private final String expr;

    private DeleteParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.expr = builder.expr;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getExpr() {
        return this.expr;
    }

    public String toString() {
        return "DeleteParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", expr='" + this.expr + '\'' + '}';
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private String partitionName = "";
        private String expr;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withExpr(String expr) {
            if (expr == null) {
                throw new IllegalArgumentException("expr cannot be null");
            }
            this.expr = expr;
            return this;
        }

        public DeleteParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.expr, "Expression");
            return new DeleteParam(this);
        }
    }
}

