/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.dml.AnnSearchParam;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.List;

public class HybridSearchParam {
    private String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final List<AnnSearchParam> searchRequests;
    private final BaseRanker ranker;
    private final Long topK;
    private final List<String> outFields;
    private final long offset;
    private final int roundDecimal;
    private final ConsistencyLevelEnum consistencyLevel;
    private final String groupByFieldName;
    private final Integer groupSize;
    private final Boolean strictGroupSize;

    private HybridSearchParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.searchRequests = builder.searchRequests;
        this.ranker = builder.ranker;
        this.topK = builder.topK;
        this.outFields = builder.outFields;
        this.offset = builder.offset;
        this.roundDecimal = builder.roundDecimal;
        this.consistencyLevel = builder.consistencyLevel;
        this.groupByFieldName = builder.groupByFieldName;
        this.groupSize = builder.groupSize;
        this.strictGroupSize = builder.strictGroupSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public List<AnnSearchParam> getSearchRequests() {
        return this.searchRequests;
    }

    public BaseRanker getRanker() {
        return this.ranker;
    }

    public Long getTopK() {
        return this.topK;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public Boolean getStrictGroupSize() {
        return this.strictGroupSize;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String toString() {
        return "HybridSearchParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", searchRequests=" + this.searchRequests + ", ranker=" + this.ranker + ", topK=" + this.topK + ", outFields=" + this.outFields + ", offset=" + this.offset + ", roundDecimal=" + this.roundDecimal + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", groupByFieldName='" + this.groupByFieldName + '\'' + ", groupSize=" + this.groupSize + ", strictGroupSize=" + this.strictGroupSize + '}';
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private final List<AnnSearchParam> searchRequests = Lists.newArrayList();
        private BaseRanker ranker = null;
        private Long topK;
        private final List<String> outFields = Lists.newArrayList();
        private Long offset = 0L;
        private Integer roundDecimal = -1;
        private ConsistencyLevelEnum consistencyLevel = null;
        private String groupByFieldName = null;
        private Integer groupSize = null;
        private Boolean strictGroupSize = null;

        Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(List<String> partitionNames) {
            if (partitionNames == null) {
                throw new IllegalArgumentException("partitionNames cannot be null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder addSearchRequest(AnnSearchParam searchParam) {
            if (searchParam == null) {
                throw new IllegalArgumentException("searchParam cannot be null");
            }
            this.searchRequests.add(searchParam);
            return this;
        }

        public Builder withRanker(BaseRanker ranker) {
            if (ranker == null) {
                throw new IllegalArgumentException("ranker cannot be null");
            }
            this.ranker = ranker;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Deprecated
        public Builder withTopK(Integer topK) {
            if (topK == null) {
                throw new IllegalArgumentException("topK cannot be null");
            }
            this.topK = topK.longValue();
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.topK = limit;
            return this;
        }

        public Builder withOutFields(List<String> outFields) {
            if (outFields == null) {
                throw new IllegalArgumentException("outFields cannot be null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(String fieldName) {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName cannot be null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        public Builder withOffset(Long offset) {
            if (offset == null) {
                throw new IllegalArgumentException("offset cannot be null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withRoundDecimal(Integer decimal) {
            if (decimal == null) {
                throw new IllegalArgumentException("decimal cannot be null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withGroupByFieldName(String groupByFieldName) {
            if (groupByFieldName == null) {
                throw new IllegalArgumentException("groupByFieldName cannot be null");
            }
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public Builder withGroupSize(Integer groupSize) {
            if (groupSize == null) {
                throw new IllegalArgumentException("groupSize cannot be null");
            }
            this.groupSize = groupSize;
            return this;
        }

        public Builder withStrictGroupSize(Boolean strictGroupSize) {
            if (strictGroupSize == null) {
                throw new IllegalArgumentException("strictGroupSize cannot be null");
            }
            this.strictGroupSize = strictGroupSize;
            return this;
        }

        public HybridSearchParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.ranker == null) {
                throw new ParamException("Must specify a Ranker by withRanker()");
            }
            if (this.searchRequests.isEmpty()) {
                throw new ParamException("At least a search request is required");
            }
            int vectorSize = 0;
            for (AnnSearchParam req : this.searchRequests) {
                if (vectorSize == 0) {
                    vectorSize = req.getVectors().size();
                    continue;
                }
                if (vectorSize == req.getVectors().size()) continue;
                throw new ParamException("Vector number of each AnnSearchParam must be equal");
            }
            if (this.topK <= 0L) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.groupByFieldName != null && this.groupSize != null && this.groupSize <= 0) {
                throw new ParamException("GroupSize value cannot be zero or negative");
            }
            return new HybridSearchParam(this);
        }
    }
}

