/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class GetIdsParam {
    private final String collectionName;
    private final List<?> primaryIds;
    private final List<String> outputFields;
    private final ConsistencyLevelEnum consistencyLevel;

    private GetIdsParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.primaryIds = builder.primaryIds;
        this.outputFields = builder.outputFields;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<?> getPrimaryIds() {
        return this.primaryIds;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String toString() {
        return "GetIdsParam{collectionName='" + this.collectionName + '\'' + ", primaryIds=" + this.primaryIds + ", outputFields=" + this.outputFields + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + '}';
    }

    public static class Builder<T> {
        private String collectionName;
        private final List<T> primaryIds = new ArrayList<T>();
        private final List<String> outputFields = new ArrayList<String>();
        private ConsistencyLevelEnum consistencyLevel = null;

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withOutputFields(List<String> outputFields) {
            if (outputFields == null) {
                throw new IllegalArgumentException("outputFields cannot be null");
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public Builder withPrimaryIds(List<T> primaryIds) {
            if (primaryIds == null) {
                throw new IllegalArgumentException("primaryIds cannot be null");
            }
            this.primaryIds.addAll(primaryIds);
            return this;
        }

        public Builder addPrimaryId(T primaryId) {
            if (primaryId == null) {
                throw new IllegalArgumentException("primaryId cannot be null");
            }
            this.primaryIds.add(primaryId);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public GetIdsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.primaryIds)) {
                throw new ParamException("PrimaryIds cannot be empty");
            }
            return new GetIdsParam(this);
        }
    }
}

