/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SearchSimpleParam {
    private final String collectionName;
    private final List<?> vectors;
    private final List<String> outputFields;
    private final String filter;
    private final Long offset;
    private final int limit;
    private final Map<String, Object> params;
    private final ConsistencyLevelEnum consistencyLevel;

    private SearchSimpleParam(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.vectors = builder.vectors;
        this.outputFields = builder.outputFields;
        this.filter = builder.filter;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.params = builder.params;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public String getFilter() {
        return this.filter;
    }

    public Long getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String toString() {
        return "SearchSimpleParam{collectionName='" + this.collectionName + '\'' + ", params='" + this.params + '\'' + ", filter='" + this.filter + '\'' + ", NQ=" + this.vectors.size() + ", limit=" + this.limit + ", offset=" + this.offset + ", outputFields=" + this.outputFields + ", consistencyLevel='" + (Object)((Object)this.consistencyLevel) + '\'' + '}';
    }

    public static class Builder {
        private String collectionName;
        private List<?> vectors;
        private final List<String> outputFields = Lists.newArrayList();
        private String filter = "";
        private Long offset = 0L;
        private int limit = 10;
        private ConsistencyLevelEnum consistencyLevel = null;
        private final Map<String, Object> params = new HashMap<String, Object>();

        Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFilter(String filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter cannot be null");
            }
            this.filter = filter;
            return this;
        }

        public Builder withOutputFields(List<String> outputFields) {
            if (outputFields == null) {
                throw new IllegalArgumentException("outputFields cannot be null");
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public Builder withVectors(List<?> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            return this;
        }

        public Builder withOffset(Long offset) {
            if (offset == null) {
                throw new IllegalArgumentException("offset cannot be null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.limit = Math.toIntExact(limit);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public SearchSimpleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.vectors)) {
                throw new ParamException("vector cannot be empty");
            }
            if (this.offset < 0L) {
                throw new ParamException("The offset value cannot be less than 0");
            }
            if (this.limit < 0) {
                throw new ParamException("The limit value cannot be less than 0");
            }
            this.params.put("offset", this.offset);
            return new SearchSimpleParam(this);
        }
    }
}

