/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DescribeIndexParam {
    private final String databaseName;
    private final String collectionName;
    private final String indexName;
    private final String fieldName;

    private DescribeIndexParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.indexName = builder.indexName;
        this.fieldName = builder.fieldName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "DescribeIndexParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", indexName='" + this.indexName + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private String indexName = "";
        private String fieldName = "";

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        @Deprecated
        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder withFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public DescribeIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new DescribeIndexParam(this);
        }
    }
}

