/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DropResourceGroupParam {
    private final String groupName;

    private DropResourceGroupParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.groupName = builder.groupName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String toString() {
        return "DropResourceGroupParam{groupName='" + this.groupName + '\'' + '}';
    }

    public static final class Builder {
        private String groupName;

        private Builder() {
        }

        public Builder withGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Group name cannot be null");
            }
            this.groupName = groupName;
            return this;
        }

        public DropResourceGroupParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.groupName, "Group name");
            return new DropResourceGroupParam(this);
        }
    }
}

