/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class SelectGrantForRoleAndObjectParam {
    private final String roleName;
    private final String object;
    private final String objectName;

    private SelectGrantForRoleAndObjectParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.roleName = builder.roleName;
        this.object = builder.object;
        this.objectName = builder.objectName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getObject() {
        return this.object;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return "SelectGrantForRoleAndObjectParam{roleName='" + this.roleName + '\'' + ", object='" + this.object + '\'' + ", objectName='" + this.objectName + '\'' + '}';
    }

    public static final class Builder {
        private String roleName;
        private String object;
        private String objectName;

        private Builder() {
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Role name cannot be null");
            }
            this.roleName = roleName;
            return this;
        }

        public Builder withObject(String object) {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            this.object = object;
            return this;
        }

        public Builder withObjectName(String objectName) {
            if (objectName == null) {
                throw new IllegalArgumentException("Object name cannot be null");
            }
            this.objectName = objectName;
            return this;
        }

        public SelectGrantForRoleAndObjectParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            ParamUtils.CheckNullEmptyString(this.object, "Object");
            ParamUtils.CheckNullEmptyString(this.objectName, "ObjectName");
            return new SelectGrantForRoleAndObjectParam(this);
        }
    }
}

