/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.exception;

import io.milvus.v2.exception.ErrorCode;

public class MilvusClientException
extends RuntimeException {
    private final ErrorCode errorCode;
    private int serverErrCode = 0;
    private int legacyServerCode = 0;

    public MilvusClientException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public MilvusClientException(ErrorCode errorCode, Throwable e) {
        super(e);
        this.errorCode = errorCode;
    }

    public MilvusClientException(ErrorCode errorCode, String message, int serverErrCode, int legacyServerCode) {
        super(message);
        this.errorCode = errorCode;
        this.serverErrCode = serverErrCode;
        this.legacyServerCode = legacyServerCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public int getServerErrCode() {
        return this.serverErrCode;
    }

    public int getLegacyServerCode() {
        return this.legacyServerCode;
    }

    @Override
    public String toString() {
        String s = super.toString();
        String codeMsg = " ErrorCode: " + this.errorCode.name();
        if (this.serverErrCode > 0) {
            codeMsg = codeMsg + ", ServerCode: " + this.serverErrCode;
        } else if (this.legacyServerCode > 0) {
            codeMsg = codeMsg + ", ServerCode: " + this.legacyServerCode;
        }
        return s + codeMsg;
    }
}

