/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index;

import io.milvus.grpc.AllocTimestampRequest;
import io.milvus.grpc.AllocTimestampResponse;
import io.milvus.grpc.AlterIndexRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.IndexBuildState;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.index.request.AlterIndexPropertiesReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexPropertiesReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexService
extends BaseService {
    public Void createIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateIndexReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        for (IndexParam indexParam : request.getIndexParams()) {
            Map<String, Object> extraParams;
            String fieldName = indexParam.getFieldName();
            String indexName = indexParam.getIndexName();
            String title = String.format("Create index for field: '%s' in collection: '%s' in database: '%s'", fieldName, collectionName, dbName);
            CreateIndexRequest.Builder builder = CreateIndexRequest.newBuilder();
            builder.setCollectionName(collectionName).setFieldName(fieldName).addExtraParams(KeyValuePair.newBuilder().setKey("index_type").setValue(indexParam.getIndexType().getName()).build());
            if (StringUtils.isNotEmpty((CharSequence)indexName)) {
                builder.setIndexName(indexName);
            }
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                builder.setDbName(dbName);
            }
            if (indexParam.getMetricType() != null) {
                builder.addExtraParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(indexParam.getMetricType().name()).build());
            }
            if ((extraParams = indexParam.getExtraParams()) != null && !extraParams.isEmpty()) {
                for (String key : extraParams.keySet()) {
                    builder.addExtraParams(KeyValuePair.newBuilder().setKey(key).setValue(extraParams.get(key).toString()).build());
                }
            }
            Status status = blockingStub.createIndex(builder.build());
            this.rpcUtils.handleResponse(title, status);
            if (!request.getSync().booleanValue()) continue;
            this.WaitForIndexComplete(blockingStub, dbName, collectionName, fieldName, indexName, request.getTimeout());
        }
        return null;
    }

    public Void dropIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String fieldName = request.getFieldName();
        String indexName = request.getIndexName();
        String title = String.format("Drop index in collection: '%s' in database: '%s', fieldName: '%s', indexName: '%s'", collectionName, dbName, fieldName, indexName);
        DropIndexRequest.Builder builder = DropIndexRequest.newBuilder().setCollectionName(collectionName).setFieldName(fieldName == null ? "" : fieldName).setIndexName(indexName == null ? "" : indexName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.dropIndex(builder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterIndexPropertiesReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String indexName = request.getIndexName();
        String title = String.format("Alter properties of index: '%s' in collection: '%s' in database: '%s'", indexName, collectionName, dbName);
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(collectionName).setIndexName(indexName);
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addExtraParams);
        }
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexPropertiesReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String indexName = request.getIndexName();
        String title = String.format("Drop properties of index: '%s' in collection: '%s' in database: '%s'", indexName, collectionName, dbName);
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(collectionName).setIndexName(indexName).addAllDeleteKeys(request.getPropertyKeys());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public DescribeIndexResp describeIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeIndexReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String fieldName = request.getFieldName();
        String indexName = request.getIndexName();
        String title = String.format("Describe index in collection: '%s' in database: '%s', fieldName: '%s', indexName: '%s'", collectionName, dbName, fieldName, indexName);
        DescribeIndexRequest.Builder builder = DescribeIndexRequest.newBuilder().setCollectionName(collectionName).setFieldName(fieldName == null ? "" : fieldName).setIndexName(indexName == null ? "" : indexName).setTimestamp(request.getTimestamp());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        DescribeIndexResponse response = blockingStub.describeIndex(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        List<IndexDescription> indexes = response.getIndexDescriptionsList().stream().filter(index -> index.getIndexName().equals(request.getIndexName()) || index.getFieldName().equals(request.getFieldName())).collect(Collectors.toList());
        return this.convertUtils.convertToDescribeIndexResp(indexes);
    }

    public List<String> listIndexes(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListIndexesReq request) {
        DescribeIndexResponse response;
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String fieldName = request.getFieldName();
        String title = String.format("List indexes in collection: '%s' in database: '%s'", collectionName, dbName);
        DescribeIndexRequest.Builder builder = DescribeIndexRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            builder.setFieldName(fieldName);
        }
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        if ((response = blockingStub.describeIndex(builder.build())).getStatus().getErrorCode() == ErrorCode.IndexNotExist || response.getStatus().getCode() == 700) {
            return new ArrayList<String>();
        }
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getIndexDescriptionsList().stream().filter(desc -> fieldName == null || desc.getFieldName().equals(fieldName)).map(IndexDescription::getIndexName).collect(Collectors.toList());
    }

    private void WaitForIndexComplete(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String dbName, String collectionName, String fieldName, String indexName, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        AllocTimestampResponse allocTsResp = blockingStub.allocTimestamp(AllocTimestampRequest.newBuilder().build());
        this.rpcUtils.handleResponse("Alloc timestamp", allocTsResp.getStatus());
        long serverTs = allocTsResp.getTimestamp();
        while (true) {
            DescribeIndexReq describeIndexReq;
            DescribeIndexResp response;
            List<DescribeIndexResp.IndexDesc> descs;
            if (CollectionUtils.isEmpty(descs = (response = this.describeIndex(blockingStub, describeIndexReq = DescribeIndexReq.builder().databaseName(dbName).collectionName(collectionName).fieldName(fieldName).indexName(indexName).timestamp(serverTs).build())).getIndexDescriptions())) {
                String msg = String.format("No index is found, indexName: '%s' fieldName: '%s' in collection: '%s' in database: '%s'", fieldName, indexName, collectionName, dbName);
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, msg);
            }
            boolean allIndexBuildCompleted = true;
            for (DescribeIndexResp.IndexDesc desc : descs) {
                if (desc.getIndexState() == IndexBuildState.Failed) {
                    throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Index is failed, reason: " + desc.getIndexFailedReason());
                }
                if (desc.getIndexState() == IndexBuildState.Finished) continue;
                allIndexBuildCompleted = false;
            }
            if (allIndexBuildCompleted) {
                return;
            }
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Create index timeout");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread was interrupted, failed to complete operation");
                return;
            }
        }
    }
}

