/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index.request;

import io.milvus.v2.common.IndexParam;
import java.util.List;

public class CreateIndexReq {
    private String databaseName;
    private String collectionName;
    private List<IndexParam> indexParams;
    private Boolean sync = Boolean.TRUE;
    private Long timeout = 60000L;

    private CreateIndexReq(CreateIndexReqBuilder builder) {
        if (builder.collectionName == null) {
            throw new IllegalArgumentException("Collection name cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.indexParams = builder.indexParams;
        this.sync = builder.sync;
        this.timeout = builder.timeout;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        if (collectionName == null) {
            throw new IllegalArgumentException("Collection name cannot be null");
        }
        this.collectionName = collectionName;
    }

    public List<IndexParam> getIndexParams() {
        return this.indexParams;
    }

    public void setIndexParams(List<IndexParam> indexParams) {
        this.indexParams = indexParams;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public void setSync(Boolean sync) {
        this.sync = sync;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "CreateIndexReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", indexParams=" + this.indexParams + ", sync=" + this.sync + ", timeout=" + this.timeout + '}';
    }

    public static CreateIndexReqBuilder builder() {
        return new CreateIndexReqBuilder();
    }

    public static class CreateIndexReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<IndexParam> indexParams;
        private Boolean sync = Boolean.TRUE;
        private Long timeout = 60000L;

        private CreateIndexReqBuilder() {
        }

        public CreateIndexReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public CreateIndexReqBuilder collectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("Collection name cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public CreateIndexReqBuilder indexParams(List<IndexParam> indexParams) {
            this.indexParams = indexParams;
            return this;
        }

        public CreateIndexReqBuilder sync(Boolean sync) {
            this.sync = sync;
            return this;
        }

        public CreateIndexReqBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public CreateIndexReq build() {
            return new CreateIndexReq(this);
        }
    }
}

