/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.partition.request;

import java.util.ArrayList;
import java.util.List;

public class LoadPartitionsReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private Integer numReplicas;
    private Boolean sync;
    private Long timeout;
    private Boolean refresh;
    private List<String> loadFields;
    private Boolean skipLoadDynamicField;
    private List<String> resourceGroups;

    private LoadPartitionsReq(LoadPartitionsReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.numReplicas = builder.numReplicas;
        this.sync = builder.sync;
        this.timeout = builder.timeout;
        this.refresh = builder.refresh;
        this.loadFields = builder.loadFields;
        this.skipLoadDynamicField = builder.skipLoadDynamicField;
        this.resourceGroups = builder.resourceGroups;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public void setNumReplicas(Integer numReplicas) {
        this.numReplicas = numReplicas;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public void setSync(Boolean sync) {
        this.sync = sync;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Boolean refresh) {
        this.refresh = refresh;
    }

    public List<String> getLoadFields() {
        return this.loadFields;
    }

    public void setLoadFields(List<String> loadFields) {
        this.loadFields = loadFields;
    }

    public Boolean getSkipLoadDynamicField() {
        return this.skipLoadDynamicField;
    }

    public void setSkipLoadDynamicField(Boolean skipLoadDynamicField) {
        this.skipLoadDynamicField = skipLoadDynamicField;
    }

    public List<String> getResourceGroups() {
        return this.resourceGroups;
    }

    public void setResourceGroups(List<String> resourceGroups) {
        this.resourceGroups = resourceGroups;
    }

    public String toString() {
        return "LoadPartitionsReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", numReplicas=" + this.numReplicas + ", sync=" + this.sync + ", timeout=" + this.timeout + ", refresh=" + this.refresh + ", loadFields=" + this.loadFields + ", skipLoadDynamicField=" + this.skipLoadDynamicField + ", resourceGroups=" + this.resourceGroups + '}';
    }

    public static LoadPartitionsReqBuilder builder() {
        return new LoadPartitionsReqBuilder();
    }

    public static class LoadPartitionsReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<String> partitionNames = new ArrayList<String>();
        private Integer numReplicas = 1;
        private Boolean sync = Boolean.TRUE;
        private Long timeout = 60000L;
        private Boolean refresh = Boolean.FALSE;
        private List<String> loadFields = new ArrayList<String>();
        private Boolean skipLoadDynamicField = Boolean.FALSE;
        private List<String> resourceGroups = new ArrayList<String>();

        private LoadPartitionsReqBuilder() {
        }

        public LoadPartitionsReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public LoadPartitionsReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public LoadPartitionsReqBuilder partitionNames(List<String> partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public LoadPartitionsReqBuilder numReplicas(Integer numReplicas) {
            this.numReplicas = numReplicas;
            return this;
        }

        public LoadPartitionsReqBuilder sync(Boolean sync) {
            this.sync = sync;
            return this;
        }

        public LoadPartitionsReqBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public LoadPartitionsReqBuilder refresh(Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public LoadPartitionsReqBuilder loadFields(List<String> loadFields) {
            this.loadFields = loadFields;
            return this;
        }

        public LoadPartitionsReqBuilder skipLoadDynamicField(Boolean skipLoadDynamicField) {
            this.skipLoadDynamicField = skipLoadDynamicField;
            return this;
        }

        public LoadPartitionsReqBuilder resourceGroups(List<String> resourceGroups) {
            this.resourceGroups = resourceGroups;
            return this;
        }

        public LoadPartitionsReq build() {
            return new LoadPartitionsReq(this);
        }
    }
}

