/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request;

import io.milvus.v2.common.ConsistencyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private List<String> outputFields;
    private List<Object> ids;
    private String filter;
    private ConsistencyLevel consistencyLevel;
    private long offset;
    private long limit;
    private boolean ignoreGrowing;
    private String timezone;
    private Map<String, Object> queryParams = new HashMap<String, Object>();
    private Map<String, Object> filterTemplateValues;

    private QueryReq(QueryReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.outputFields = builder.outputFields;
        this.ids = builder.ids;
        this.filter = builder.filter;
        this.consistencyLevel = builder.consistencyLevel;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.queryParams = builder.queryParams;
        this.filterTemplateValues = builder.filterTemplateValues;
        this.timezone = builder.timezone;
    }

    public static QueryReqBuilder builder() {
        return new QueryReqBuilder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public List<Object> getIds() {
        return this.ids;
    }

    public void setIds(List<Object> ids) {
        this.ids = ids;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setIgnoreGrowing(boolean ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, Object> queryParams) {
        this.queryParams = queryParams;
    }

    public Map<String, Object> getFilterTemplateValues() {
        return this.filterTemplateValues;
    }

    public void setFilterTemplateValues(Map<String, Object> filterTemplateValues) {
        this.filterTemplateValues = filterTemplateValues;
    }

    public String toString() {
        return "QueryReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", outputFields=" + this.outputFields + ", ids=" + this.ids + ", filter='" + this.filter + '\'' + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", offset=" + this.offset + ", limit=" + this.limit + ", ignoreGrowing=" + this.ignoreGrowing + ", timezone='" + this.timezone + '\'' + ", queryParams=" + this.queryParams + '}';
    }

    public static class QueryReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<String> partitionNames = new ArrayList<String>();
        private List<String> outputFields = Collections.singletonList("*");
        private List<Object> ids;
        private String filter = "";
        private ConsistencyLevel consistencyLevel = null;
        private long offset;
        private long limit;
        private boolean ignoreGrowing;
        private String timezone = "";
        private Map<String, Object> queryParams = new HashMap<String, Object>();
        private Map<String, Object> filterTemplateValues = new HashMap<String, Object>();

        public QueryReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public QueryReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public QueryReqBuilder partitionNames(List<String> partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public QueryReqBuilder outputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        public QueryReqBuilder ids(List<Object> ids) {
            this.ids = ids;
            return this;
        }

        public QueryReqBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public QueryReqBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public QueryReqBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public QueryReqBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public QueryReqBuilder ignoreGrowing(boolean ignoreGrowing) {
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public QueryReqBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public QueryReqBuilder queryParams(Map<String, Object> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public QueryReqBuilder filterTemplateValues(Map<String, Object> filterTemplateValues) {
            this.filterTemplateValues = filterTemplateValues;
            return this;
        }

        public QueryReq build() {
            return new QueryReq(this);
        }
    }
}

