/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.grpc.DescribeDatabaseResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class DescDBResponseWrapper {
    private final DescribeDatabaseResponse response;
    Map<String, String> pairs = new HashMap<String, String>();

    public DescDBResponseWrapper(@NonNull DescribeDatabaseResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
        response.getPropertiesList().forEach(prop -> this.pairs.put(prop.getKey(), prop.getValue()));
    }

    public String getDatabaseName() {
        return this.response.getDbName();
    }

    public Map<String, String> getProperties() {
        return this.pairs;
    }

    public List<String> getResourceGroups() {
        String value = this.pairs.get("database.resource_groups");
        if (value == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(","));
    }

    public int getReplicaNumber() {
        String value = this.pairs.get("database.replica.number");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(this.pairs.get("database.replica.number"));
    }

    public String toString() {
        return "Database Description{name:'" + this.getDatabaseName() + '\'' + ", properties:" + this.getProperties() + '}';
    }
}

