/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.Status;
import io.milvus.v2.client.RetryConfig;
import io.milvus.v2.exception.MilvusClientException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcUtils {
    protected static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);
    private RetryConfig retryConfig = RetryConfig.builder().build();

    public void retryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public void handleResponse(String requestInfo, Status status) {
        if (status.getCode() != 0 || !status.getErrorCode().equals((Object)ErrorCode.Success)) {
            int code = status.getCode();
            if (code == 0) {
                code = status.getErrorCode().getNumber();
            }
            logger.error("{} failed, error code: {}, reason: {}", new Object[]{requestInfo, io.milvus.v2.exception.ErrorCode.SERVER_ERROR.getCode(), status.getReason()});
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, status.getReason(), code, status.getErrorCode().getNumber());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} successfully!", (Object)requestInfo);
        }
    }

    public <T> T retry(Callable<T> callable) {
        int maxRetryTimes = this.retryConfig.getMaxRetryTimes();
        if (maxRetryTimes <= 1) {
            try {
                return callable.call();
            }
            catch (StatusRuntimeException e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.RPC_ERROR, (Throwable)e);
            }
            catch (MilvusClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.CLIENT_ERROR, (Throwable)e);
            }
        }
        long begin = System.currentTimeMillis();
        long maxRetryTimeoutMs = this.retryConfig.getMaxRetryTimeoutMs();
        Callable<Boolean> timeoutChecker = () -> {
            long current = System.currentTimeMillis();
            long cost = current - begin;
            if (maxRetryTimeoutMs > 0L && cost >= maxRetryTimeoutMs) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        };
        long retryIntervalMs = this.retryConfig.getInitialBackOffMs();
        for (int k = 1; k <= maxRetryTimes; ++k) {
            try {
                return callable.call();
            }
            catch (StatusRuntimeException e) {
                Status.Code code = e.getStatus().getCode();
                if (code == io.grpc.Status.DEADLINE_EXCEEDED.getCode() || code == io.grpc.Status.PERMISSION_DENIED.getCode() || code == io.grpc.Status.UNAUTHENTICATED.getCode() || code == io.grpc.Status.INVALID_ARGUMENT.getCode() || code == io.grpc.Status.ALREADY_EXISTS.getCode() || code == io.grpc.Status.RESOURCE_EXHAUSTED.getCode() || code == io.grpc.Status.UNIMPLEMENTED.getCode()) {
                    String msg = String.format("Encounter rpc error that cannot be retried, reason: %s", new Object[]{e});
                    logger.error(msg);
                    throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.RPC_ERROR, msg);
                }
                try {
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", maxRetryTimeoutMs, maxRetryTimes, k, e.getMessage());
                        logger.warn(msg);
                        throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                    }
                }
                catch (Exception exception) {}
            }
            catch (MilvusClientException e) {
                try {
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", maxRetryTimeoutMs, maxRetryTimes, k, e.getMessage());
                        logger.warn(msg);
                        throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.retryConfig.isRetryOnRateLimit() || e.getLegacyServerCode() != ErrorCode.RateLimit.getNumber() && e.getServerErrCode() != 8) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.CLIENT_ERROR, (Throwable)e);
            }
            try {
                if (k >= maxRetryTimes) {
                    String msg = String.format("Finish %d retry times, stop retry", maxRetryTimes);
                    logger.warn(msg);
                    throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                }
                if (k > 3) {
                    logger.warn(String.format("Retry(%d) with interval %dms", k, retryIntervalMs));
                }
                TimeUnit.MILLISECONDS.sleep(retryIntervalMs);
                if ((retryIntervalMs *= (long)this.retryConfig.getBackOffMultiplier()) <= this.retryConfig.getMaxBackOffMs()) continue;
                retryIntervalMs = this.retryConfig.getMaxBackOffMs();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

