/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.common;

import io.mockk.proxy.Cancelable;
import io.mockk.proxy.MockKAgentException;
import io.mockk.proxy.MockKAgentLogger;
import io.mockk.proxy.MockKInstantiatior;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKProxyMaker;
import io.mockk.proxy.common.CancelableResult;
import io.mockk.proxy.common.ProxyMaker;
import io.mockk.proxy.common.transformation.InlineInstrumentation;
import io.mockk.proxy.common.transformation.SubclassInstrumentation;
import io.mockk.proxy.common.transformation.TransformationRequest;
import io.mockk.proxy.common.transformation.TransformationType;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u0000 )2\u00020\u0001:\u0001)B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010H\u0002JE\u0010\u0016\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\f2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002JW\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001f\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00102\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010#J=\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00102\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100!H\u0002\u00a2\u0006\u0002\u0010%J7\u0010&\u001a\u00020\u0015\"\b\b\u0000\u0010\u0011*\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00102\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100!H\u0002\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/mockk/proxy/common/ProxyMaker;", "Lio/mockk/proxy/MockKProxyMaker;", "log", "Lio/mockk/proxy/MockKAgentLogger;", "inliner", "Lio/mockk/proxy/common/transformation/InlineInstrumentation;", "subclasser", "Lio/mockk/proxy/common/transformation/SubclassInstrumentation;", "instantiator", "Lio/mockk/proxy/MockKInstantiatior;", "handlers", "", "", "Lio/mockk/proxy/MockKInvocationHandler;", "(Lio/mockk/proxy/MockKAgentLogger;Lio/mockk/proxy/common/transformation/InlineInstrumentation;Lio/mockk/proxy/common/transformation/SubclassInstrumentation;Lio/mockk/proxy/MockKInstantiatior;Ljava/util/Map;)V", "findActualClassToBeProxied", "Ljava/lang/Class;", "T", "clazz", "inline", "Lkotlin/Function0;", "", "instantiate", "proxyClass", "useDefaultConstructor", "", "instance", "(Ljava/lang/Class;Ljava/lang/Class;ZLjava/lang/Object;)Ljava/lang/Object;", "newInstanceViaDefaultConstructor", "cls", "proxy", "Lio/mockk/proxy/Cancelable;", "interfaces", "", "handler", "(Ljava/lang/Class;[Ljava/lang/Class;Lio/mockk/proxy/MockKInvocationHandler;ZLjava/lang/Object;)Lio/mockk/proxy/Cancelable;", "subclass", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/Class;", "throwIfNotPossibleToProxy", "(Ljava/lang/Class;[Ljava/lang/Class;)V", "warnOnFinalMethods", "Companion", "mockk-agent-api"})
public final class ProxyMaker
implements MockKProxyMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockKAgentLogger log;
    @Nullable
    private final InlineInstrumentation inliner;
    @NotNull
    private final SubclassInstrumentation subclasser;
    @NotNull
    private final MockKInstantiatior instantiator;
    @NotNull
    private final Map<Object, MockKInvocationHandler> handlers;
    @NotNull
    private static final Set<Class<? extends Serializable>> notMockableClasses;

    public ProxyMaker(@NotNull MockKAgentLogger log, @Nullable InlineInstrumentation inliner, @NotNull SubclassInstrumentation subclasser, @NotNull MockKInstantiatior instantiator, @NotNull Map<Object, MockKInvocationHandler> handlers) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)subclasser, (String)"subclasser");
        Intrinsics.checkNotNullParameter((Object)instantiator, (String)"instantiator");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        this.log = log;
        this.inliner = inliner;
        this.subclasser = subclasser;
        this.instantiator = instantiator;
        this.handlers = handlers;
    }

    @Override
    @NotNull
    public <T> Cancelable<T> proxy(@NotNull Class<T> clazz, @NotNull Class<?>[] interfaces, @NotNull MockKInvocationHandler handler, boolean useDefaultConstructor, @Nullable Object instance) {
        Class<T> clazz2;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(interfaces, (String)"interfaces");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.throwIfNotPossibleToProxy(clazz, interfaces);
        Class<T> actualClass = this.findActualClassToBeProxied(clazz);
        Function0<Unit> cancellation = this.inline(actualClass);
        CancelableResult result = new CancelableResult(null, cancellation, 1, null);
        try {
            clazz2 = this.subclass(actualClass, interfaces);
        }
        catch (Exception ex) {
            result.cancel();
            throw new MockKAgentException("Failed to subclass " + actualClass, ex);
        }
        Class<T> proxyClass = clazz2;
        try {
            T proxy2 = this.instantiate(actualClass, proxyClass, useDefaultConstructor, instance);
            this.handlers.put(proxy2, handler);
            return result.withValue(proxy2).alsoOnCancel((Function0<Unit>)((Function0)new Function0<Unit>(this, proxy2){
                final /* synthetic */ ProxyMaker this$0;
                final /* synthetic */ T $proxy;
                {
                    this.this$0 = $receiver;
                    this.$proxy = $proxy;
                    super(0);
                }

                public final void invoke() {
                    ProxyMaker.access$getHandlers$p(this.this$0).remove(this.$proxy);
                }
            }));
        }
        catch (Exception e) {
            result.cancel();
            throw new MockKAgentException("Instantiation exception", e);
        }
    }

    private final <T> T instantiate(Class<T> clazz, Class<T> proxyClass, boolean useDefaultConstructor, Object instance) {
        T t;
        if (instance != null) {
            this.log.trace("Attaching to object mock for " + clazz);
            T t2 = clazz.cast(instance);
            t = t2;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"{\n                log.tr\u2026t(instance)\n            }");
        } else if (useDefaultConstructor) {
            this.log.trace("Instantiating proxy for " + clazz + " via default constructor");
            T t3 = clazz.cast(this.newInstanceViaDefaultConstructor(proxyClass));
            t = t3;
            Intrinsics.checkNotNullExpressionValue(t3, (String)"{\n                log.tr\u2026roxyClass))\n            }");
        } else {
            this.log.trace("Instantiating proxy for " + clazz + " via instantiator");
            t = this.instantiator.instance(proxyClass);
        }
        return t;
    }

    private final <T> Function0<Unit> inline(Class<T> clazz) {
        Function0<Unit> function0;
        Set superclasses = ProxyMaker.Companion.getAllSuperclasses(clazz);
        if (this.inliner != null) {
            TransformationRequest transformRequest = new TransformationRequest(superclasses, TransformationType.SIMPLE, false, 4, null);
            function0 = this.inliner.execute(transformRequest);
        } else {
            if (!Modifier.isFinal(clazz.getModifiers())) {
                this.warnOnFinalMethods(clazz);
            }
            function0 = inline.1.INSTANCE;
        }
        return function0;
    }

    private final <T> Class<T> findActualClassToBeProxied(Class<T> clazz) {
        KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
        if (!kClass.isSealed()) {
            return clazz;
        }
        Object object = (KClass)CollectionsKt.firstOrNull((List)kClass.getSealedSubclasses());
        if (object == null || (object = JvmClassMappingKt.getJavaClass((KClass)object)) == null) {
            throw new IllegalStateException(("Unable to create proxy for sealed class " + clazz + ", no subclasses available").toString());
        }
        Object subclass = object;
        this.log.trace("Class " + clazz + " is sealed, will use its subclass " + subclass + " to build proxy");
        Class<T> clazz2 = this.findActualClassToBeProxied((Class<T>)subclass);
        Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<T of io.mockk.proxy.common.ProxyMaker.findActualClassToBeProxied>");
        return clazz2;
    }

    private final <T> Class<T> subclass(Class<T> clazz, Class<?>[] interfaces) {
        Class<T> clazz2;
        if (Modifier.isFinal(clazz.getModifiers())) {
            this.log.trace("Taking instance of " + clazz + " itself because it is final.");
            clazz2 = clazz;
        } else if (interfaces.length == 0 && !Modifier.isAbstract(clazz.getModifiers()) && this.inliner != null) {
            this.log.trace("Taking instance of " + clazz + " itself because it is not abstract and no additional interfaces specified.");
            clazz2 = clazz;
        } else {
            this.log.trace("Building subclass proxy for " + clazz + " with additional interfaces " + ArraysKt.toList((Object[])interfaces));
            clazz2 = this.subclasser.subclass(clazz, interfaces);
        }
        return clazz2;
    }

    private final <T> void throwIfNotPossibleToProxy(Class<T> clazz, Class<?>[] interfaces) {
        if (clazz.isPrimitive()) {
            throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is a primitive");
        }
        if (clazz.isArray()) {
            throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is an array");
        }
        Iterable iterable = notMockableClasses;
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        if (CollectionsKt.contains((Iterable)iterable, clazz)) {
            throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is one of excluded classes");
        }
        if (!(interfaces.length == 0) && Modifier.isFinal(clazz.getModifiers())) {
            throw new MockKAgentException("Failed to create proxy for " + clazz + ".\nMore interfaces requested and class is final.");
        }
    }

    private final Object newInstanceViaDefaultConstructor(Class<?> cls) {
        try {
            Constructor<?> defaultConstructor = cls.getDeclaredConstructor(new Class[0]);
            try {
                defaultConstructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object obj = defaultConstructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"defaultConstructor.newInstance()");
            return obj;
        }
        catch (Exception e) {
            throw new MockKAgentException("Default constructor instantiation exception", e);
        }
    }

    private final void warnOnFinalMethods(Class<?> clazz) {
        for (Method method : ProxyMaker.Companion.gatherAllMethods(clazz)) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            this.log.debug("It is impossible to intercept calls to " + method + " for " + method.getDeclaringClass() + " because it is final");
        }
    }

    public static final /* synthetic */ Map access$getHandlers$p(ProxyMaker $this) {
        return $this.handlers;
    }

    static {
        Object[] objectArray = new Class[]{Class.class, Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, String.class};
        notMockableClasses = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/mockk/proxy/common/ProxyMaker$Companion;", "", "()V", "notMockableClasses", "", "Ljava/lang/Class;", "Ljava/io/Serializable;", "addInterfaces", "", "result", "", "clazz", "gatherAllMethods", "", "Ljava/lang/reflect/Method;", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", "getAllSuperclasses", "cls", "mockk-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        private final Method[] gatherAllMethods(Class<?> clazz) {
            Method[] methodArray;
            if (clazz.getSuperclass() == null) {
                Method[] methodArray2 = clazz.getDeclaredMethods();
                methodArray = methodArray2;
                Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"{\n                clazz.\u2026aredMethods\n            }");
            } else {
                Class<?> clazz2 = clazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz.superclass");
                Object[] objectArray = this.gatherAllMethods(clazz2);
                Method[] methodArray3 = clazz.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray3, (String)"clazz.declaredMethods");
                methodArray = (Method[])ArraysKt.plus((Object[])objectArray, (Object[])methodArray3);
            }
            return methodArray;
        }

        private final Set<Class<?>> getAllSuperclasses(Class<?> cls) {
            Set result = new LinkedHashSet();
            Class<?> clazz = cls;
            while (true) {
                result.add(clazz);
                this.addInterfaces(result, clazz);
                if (clazz.getSuperclass() == null) break;
            }
            return result;
        }

        private final void addInterfaces(Set<Class<?>> result, Class<?> clazz) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
            for (Class<?> intf : classArray) {
                Intrinsics.checkNotNullExpressionValue(intf, (String)"intf");
                if (!result.add(intf)) continue;
                this.addInterfaces(result, intf);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

