/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.LstFormatVersion;
import io.moderne.serialization.TreeSerializer;
import io.moderne.serialization.bloom.Bloom;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.polyglot.NoopProgressBar;
import org.openrewrite.polyglot.ProgressBar;
import org.openrewrite.polyglot.RemoteProgressBarSender;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

@Mojo(name="compileLst", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class ModerneCompileLstMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RuntimeInformation runtime;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="moderne.lstOutputDirectory", defaultValue="${project.build.directory}/.moderne/build/testrun", required=true)
    private File outputPath;
    @Parameter(property="moderne.cli.port", defaultValue="-1")
    private int cliPort;

    public void execute() throws MojoExecutionException {
        if (!this.outputPath.exists() && !this.outputPath.mkdirs()) {
            throw new MojoExecutionException("Unable to create output directory.");
        }
        String astWriteVersion = ModerneCompileLstMojo.getVersion("/ast-write-version.txt");
        String buildPluginVersion = ModerneCompileLstMojo.getVersion("/plugin-version.txt");
        LstProvenance lstProvenance = new LstProvenance(Tree.randomId(), LstProvenance.Type.Maven, buildPluginVersion, astWriteVersion, Instant.now());
        AtomicLong weight = new AtomicLong();
        try (NoopProgressBar progressBar = this.cliPort == -1 ? new NoopProgressBar() : new RemoteProgressBarSender(this.cliPort);
             BufferedWriter manifest = Files.newBufferedWriter(this.outputPath.toPath().resolve("manifest.csv"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            Bloom bloom = Bloom.construct(new long[0], 1.0);
            Stream<SourceFile> asts = this.listAsts((ProgressBar)progressBar).map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().addIfAbsent((Marker)lstProvenance))).peek(sourceFile -> {
                try {
                    manifest.write(String.format("%s,%s,%s,%s\n", sourceFile.getSourcePath(), ModerneCompileLstMojo.getSourceFileType(sourceFile.getClass()), "moderne-maven-plugin", buildPluginVersion));
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }).peek(sourceFile -> weight.addAndGet(sourceFile.getWeight(t2 -> {
                int id = System.identityHashCode(t2);
                if (bloom.mayContain(id)) {
                    return false;
                }
                bloom.add(id);
                return true;
            })));
            Path moduleDirectory = this.getRelativeModuleDirectory();
            Path lstOutputDirectory = moduleDirectory == null ? this.outputPath.toPath() : this.outputPath.toPath().resolve(moduleDirectory);
            TreeSerializer.builder().lstVersion(LstFormatVersion.V2).build().write(asts, lstOutputDirectory, new CompressionAlgorithm[0]);
            try (OutputStream os = Files.newOutputStream(lstOutputDirectory.resolve("project.properties"), new OpenOption[0]);){
                Properties p2 = new Properties();
                p2.put("weight", Long.toString(weight.get()));
                p2.put("mavenProjectName", this.project.getName());
                p2.setProperty("buildPluginName", "moderne-maven-plugin");
                p2.setProperty("buildPluginVersion", buildPluginVersion);
                p2.setProperty("astWriteVersion", astWriteVersion);
                p2.store(os, null);
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        catch (DependencyResolutionRequiredException e3) {
            throw new MojoExecutionException((Throwable)e3);
        }
    }

    private static String getSourceFileType(Class<?> clazz) {
        StringBuilder simpleName = new StringBuilder(clazz.getSimpleName());
        while (clazz.isMemberClass()) {
            Class<?> enclosingClass = clazz.getEnclosingClass();
            simpleName.insert(0, enclosingClass.getSimpleName() + ".");
            clazz = clazz.getEnclosingClass();
        }
        return simpleName.toString();
    }

    @Nullable
    private Path getRelativeModuleDirectory() throws MojoExecutionException {
        try {
            Path moduleDir = this.project.getExecutionProject().getBasedir().getCanonicalFile().toPath();
            Path baseDir = this.mavenSession.getTopLevelProject().getBasedir().getCanonicalFile().toPath();
            if (baseDir.equals(moduleDir)) {
                return null;
            }
            return baseDir.relativize(moduleDir);
        }
        catch (Exception e2) {
            throw new MojoExecutionException("Unable to resolve LST folder", e2);
        }
    }

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getExecutionProject().getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getExecutionProject().getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getExecutionProject().getProperties()));
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e2);
            }
        }
        return env.build();
    }

    protected Stream<SourceFile> listAsts(final ProgressBar progressBar) throws MojoExecutionException, DependencyResolutionRequiredException {
        Path baseDir = ModerneCompileLstMojo.repositoryRoot(Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]));
        Environment env = this.environment();
        List styles = this.loadStyles(this.project.getExecutionProject(), env);
        this.getLog().info((CharSequence)String.format("Using active styles(s) %s", styles.stream().map(NamedStyles::getName).collect(Collectors.toList())));
        MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, (Collection)this.getExclusions(), (Collection)this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter, true);
        ParsingExecutionContextView ctx = ParsingExecutionContextView.view((ExecutionContext)new InMemoryExecutionContext());
        ctx.setParsingListener(new ParsingEventListener(){

            public void intermediateMessage(String stateMessage) {
                progressBar.intermediateResult(stateMessage);
            }

            public void startedParsing(Parser.Input input) {
                progressBar.setExtraMessage(input.getPath().toString());
            }

            public void parsed(Parser.Input input, SourceFile sourceFile) {
                progressBar.step();
            }
        });
        return projectParser.listSourceFiles(this.project.getExecutionProject(), styles, (ExecutionContext)ctx);
    }

    static Path repositoryRoot(Path executionRoot) {
        Path maybeBaseDir;
        for (maybeBaseDir = executionRoot; maybeBaseDir != null && !Files.exists(maybeBaseDir.resolve(".git"), new LinkOption[0]); maybeBaseDir = maybeBaseDir.getParent()) {
        }
        if (maybeBaseDir == null) {
            return executionRoot;
        }
        return maybeBaseDir;
    }

    static String getVersion(String name) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ModerneCompileLstMojo.class.getResourceAsStream(name))));
        try {
            string = reader.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        reader.close();
        return string;
    }
}

