/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.api.ConsumerConfiguration;

public abstract class SubscribeOptions {
    protected final String stream;
    protected final ConsumerConfiguration consumerConfig;

    protected SubscribeOptions(String stream, ConsumerConfiguration consumerConfig) {
        this.stream = stream;
        this.consumerConfig = consumerConfig;
    }

    public String getStream() {
        return this.stream;
    }

    public String getDurable() {
        return this.consumerConfig.getDurable();
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stream='" + this.stream + '\'' + ", " + this.consumerConfig + '}';
    }

    protected static abstract class Builder<B, SO> {
        protected String stream;
        protected String durable;
        protected ConsumerConfiguration consumerConfig;

        protected Builder() {
        }

        protected abstract B getThis();

        public B stream(String stream) {
            this.stream = stream;
            return this.getThis();
        }

        public B durable(String durable) {
            this.durable = durable;
            return this.getThis();
        }

        public B configuration(ConsumerConfiguration configuration) {
            this.consumerConfig = configuration;
            return this.getThis();
        }

        public abstract SO build();
    }
}

