/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.MirrorInfo;
import io.nats.client.api.SourceInfo;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamState;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;

public class StreamInfo
extends ApiResponse<StreamInfo> {
    private final ZonedDateTime created;
    private final StreamConfiguration config;
    private final StreamState state;
    private final ClusterInfo clusterInfo;
    private final MirrorInfo mirrorInfo;
    private final List<SourceInfo> sourceInfos;

    public StreamInfo(Message msg) {
        this(new String(msg.getData(), StandardCharsets.UTF_8));
    }

    public StreamInfo(String json) {
        super(json);
        this.created = JsonUtils.readDate(json, ApiConstants.CREATED_RE);
        this.config = StreamConfiguration.instance(JsonUtils.getJsonObject("config", json));
        this.state = new StreamState(JsonUtils.getJsonObject("state", json));
        this.clusterInfo = ClusterInfo.optionalInstance(json);
        this.mirrorInfo = MirrorInfo.optionalInstance(json);
        this.sourceInfos = SourceInfo.optionalListOf(json);
    }

    public StreamConfiguration getConfiguration() {
        return this.config;
    }

    public StreamState getStreamState() {
        return this.state;
    }

    public ZonedDateTime getCreateTime() {
        return this.created;
    }

    public MirrorInfo getMirrorInfo() {
        return this.mirrorInfo;
    }

    public List<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public String toString() {
        return "StreamInfo{created=" + this.created + ", " + JsonUtils.objectString("config", this.config) + ", " + JsonUtils.objectString("state", this.state) + ", " + JsonUtils.objectString("cluster", this.clusterInfo) + ", " + JsonUtils.objectString("mirror", this.mirrorInfo) + ", sources=" + this.sourceInfos + '}';
    }
}

