/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.impl.AckType;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

class NatsJetStreamMessage
extends NatsMessage.InternalMessage {
    private NatsJetStreamMetaData jsMetaData = null;

    NatsJetStreamMessage() {
    }

    @Override
    public void ack() {
        this.ackReply(AckType.AckAck);
    }

    @Override
    public void ackSync(Duration d) throws InterruptedException, TimeoutException {
        this.ackReplySync(AckType.AckAck, Validator.validateDurationRequired(d));
    }

    @Override
    public void nak() {
        this.ackReply(AckType.AckNak);
    }

    @Override
    public void inProgress() {
        this.ackReply(AckType.AckProgress);
    }

    @Override
    public void term() {
        this.ackReply(AckType.AckTerm);
    }

    @Override
    public NatsJetStreamMetaData metaData() {
        if (this.jsMetaData == null) {
            this.jsMetaData = new NatsJetStreamMetaData(this);
        }
        return this.jsMetaData;
    }

    @Override
    public boolean isJetStream() {
        return true;
    }

    private void ackReply(AckType ackType) {
        Connection nc = this.getJetStreamValidatedConnection();
        nc.publish(this.replyTo, ackType.bytes);
    }

    private void ackReplySync(AckType ackType, Duration dur) throws InterruptedException, TimeoutException {
        Connection nc = this.getJetStreamValidatedConnection();
        if (nc.request(this.replyTo, ackType.bytes, dur) == null) {
            throw new TimeoutException("Ack response timed out.");
        }
    }

    private Connection getJetStreamValidatedConnection() {
        if (this.getSubscription() == null) {
            throw new IllegalStateException("Message is not bound to a subscription.");
        }
        Connection c = this.getConnection();
        if (c == null) {
            throw new IllegalStateException("Message is not bound to a connection");
        }
        return c;
    }
}

