/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Options;
import io.nats.client.support.Validator;
import java.time.Duration;

public class JetStreamOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final JetStreamOptions DEFAULT_JS_OPTIONS = new Builder().build();
    private final String prefix;
    private final Duration requestTimeout;
    private final boolean publishNoAck;

    private JetStreamOptions(String prefix, Duration requestTimeout, boolean publishNoAck) {
        this.prefix = prefix;
        this.requestTimeout = requestTimeout;
        this.publishNoAck = publishNoAck;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isPublishNoAck() {
        return this.publishNoAck;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JetStreamOptions jso) {
        return new Builder(jso);
    }

    public static JetStreamOptions defaultOptions() {
        return DEFAULT_JS_OPTIONS;
    }

    public static class Builder {
        private String prefix;
        private String domain;
        private Duration requestTimeout;
        private boolean publishNoAck;

        public Builder() {
        }

        public Builder(JetStreamOptions jso) {
            if (jso != null) {
                this.prefix = jso.prefix;
                this.requestTimeout = jso.requestTimeout;
                this.publishNoAck = jso.publishNoAck;
            }
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.domain = null;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.prefix = null;
            return this;
        }

        public Builder publishNoAck(boolean publishNoAck) {
            this.publishNoAck = publishNoAck;
            return this;
        }

        public JetStreamOptions build() {
            this.prefix = this.domain == null ? this.validatePrefix(this.prefix) : this.validateDomain(this.domain);
            this.requestTimeout = this.requestTimeout == null ? DEFAULT_TIMEOUT : this.requestTimeout;
            return new JetStreamOptions(this.prefix, this.requestTimeout, this.publishNoAck);
        }

        private String validatePrefix(String prefix) {
            if (Validator.nullOrEmpty(prefix)) {
                return "$JS.API.";
            }
            String valid = Validator.validatePrefixOrDomain(prefix, "Prefix", true);
            return valid.endsWith(".") ? valid : valid + ".";
        }

        private String validateDomain(String domain) {
            if (Validator.nullOrEmpty(domain)) {
                return "$JS.API.";
            }
            String valid = Validator.validatePrefixOrDomain(domain, "Domain", true);
            if (valid.endsWith(".")) {
                return "$JS." + valid + "API.";
            }
            return "$JS." + valid + "." + "API.";
        }
    }
}

