/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;

public abstract class SubscribeOptions {
    protected final String stream;
    protected final boolean pull;
    protected final boolean bind;
    protected final ConsumerConfiguration consumerConfig;
    protected final long messageAlarmTime;

    protected SubscribeOptions(Builder builder, boolean pull, String deliverSubject, String deliverGroup) {
        this.stream = Validator.validateStreamName(builder.stream, builder.bind);
        String durable = Validator.validateMustMatchIfBothSupplied(builder.durable, builder.cc == null ? null : builder.cc.getDurable(), NatsJetStreamClientError.JsSoDurableMismatch);
        durable = Validator.validateDurable(durable, pull || builder.bind);
        deliverGroup = Validator.validateMustMatchIfBothSupplied(deliverGroup, builder.cc == null ? null : builder.cc.getDeliverGroup(), NatsJetStreamClientError.JsSoDeliverGroupMismatch);
        deliverSubject = Validator.validateMustMatchIfBothSupplied(deliverSubject, builder.cc == null ? null : builder.cc.getDeliverSubject(), NatsJetStreamClientError.JsSoDeliverSubjectGroupMismatch);
        this.consumerConfig = ConsumerConfiguration.builder(builder.cc).durable(durable).deliverSubject(deliverSubject).deliverGroup(deliverGroup).build();
        this.pull = pull;
        this.bind = builder.bind;
        this.messageAlarmTime = builder.messageAlarmTime;
    }

    public String getStream() {
        return this.stream;
    }

    public String getDurable() {
        return this.consumerConfig.getDurable();
    }

    public boolean isPull() {
        return this.pull;
    }

    public boolean isBind() {
        return this.bind;
    }

    public long getMessageAlarmTime() {
        return this.messageAlarmTime;
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stream='" + this.stream + '\'' + "bind=" + this.bind + ", " + this.consumerConfig + '}';
    }

    protected static abstract class Builder<B, SO> {
        String stream;
        boolean bind;
        String durable;
        ConsumerConfiguration cc;
        long messageAlarmTime = -1L;

        protected Builder() {
        }

        protected abstract B getThis();

        public B stream(String stream) {
            this.stream = Validator.emptyAsNull(stream);
            return this.getThis();
        }

        public B bind(boolean bind) {
            this.bind = bind;
            return this.getThis();
        }

        public B durable(String durable) {
            this.durable = Validator.emptyAsNull(durable);
            return this.getThis();
        }

        public B configuration(ConsumerConfiguration configuration) {
            this.cc = configuration;
            return this.getThis();
        }

        public B messageAlarmTime(long messageAlarmTime) {
            this.messageAlarmTime = messageAlarmTime;
            return this.getThis();
        }

        public abstract SO build();
    }
}

