/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;

public class ConsumerConfiguration
implements JsonSerializable {
    public static final Duration MIN_ACK_WAIT = Duration.ofNanos(1L);
    public static final Duration MIN_IDLE_HEARTBEAT = Duration.ZERO;
    private final DeliverPolicy deliverPolicy;
    private final AckPolicy ackPolicy;
    private final ReplayPolicy replayPolicy;
    private final String description;
    private final String durable;
    private final String deliverSubject;
    private final String deliverGroup;
    private final String filterSubject;
    private final String sampleFrequency;
    private final ZonedDateTime startTime;
    private final Duration ackWait;
    private final Duration idleHeartbeat;
    private final Long startSeq;
    private final Long maxDeliver;
    private final Long rateLimit;
    private final Long maxAckPending;
    private final Long maxPullWaiting;
    private final Boolean flowControl;
    private final Boolean headersOnly;

    public boolean wouldBeChangeTo(ConsumerConfiguration original) {
        return this.deliverPolicy != null && this.deliverPolicy != original.deliverPolicy || this.ackPolicy != null && this.ackPolicy != original.ackPolicy || this.replayPolicy != null && this.replayPolicy != original.replayPolicy || this.flowControl != null && this.flowControl != original.flowControl || this.headersOnly != null && this.headersOnly != original.headersOnly || CcNumeric.START_SEQ.wouldBeChange(this.startSeq, original.startSeq) || CcNumeric.MAX_DELIVER.wouldBeChange(this.maxDeliver, original.maxDeliver) || CcNumeric.RATE_LIMIT.wouldBeChange(this.rateLimit, original.rateLimit) || CcNumeric.MAX_ACK_PENDING.wouldBeChange(this.maxAckPending, original.maxAckPending) || CcNumeric.MAX_PULL_WAITING.wouldBeChange(this.maxPullWaiting, original.maxPullWaiting) || this.ackWait != null && !this.ackWait.equals(original.ackWait) || this.idleHeartbeat != null && !this.idleHeartbeat.equals(original.idleHeartbeat) || this.startTime != null && !this.startTime.equals(original.startTime) || this.description != null && !this.description.equals(original.description) || this.sampleFrequency != null && !this.sampleFrequency.equals(original.sampleFrequency) || this.deliverSubject != null && !this.deliverSubject.equals(original.deliverSubject) || this.deliverGroup != null && !this.deliverGroup.equals(original.deliverGroup);
    }

    private static DeliverPolicy GetOrDefault(DeliverPolicy p) {
        return p == null ? DeliverPolicy.All : p;
    }

    private static AckPolicy GetOrDefault(AckPolicy p) {
        return p == null ? AckPolicy.Explicit : p;
    }

    private static ReplayPolicy GetOrDefault(ReplayPolicy p) {
        return p == null ? ReplayPolicy.Instant : p;
    }

    ConsumerConfiguration(String json) {
        Matcher m = ApiConstants.DELIVER_POLICY_RE.matcher(json);
        this.deliverPolicy = m.find() ? ConsumerConfiguration.GetOrDefault(DeliverPolicy.get(m.group(1))) : ConsumerConfiguration.GetOrDefault((DeliverPolicy)null);
        m = ApiConstants.ACK_POLICY_RE.matcher(json);
        this.ackPolicy = m.find() ? ConsumerConfiguration.GetOrDefault(AckPolicy.get(m.group(1))) : ConsumerConfiguration.GetOrDefault((AckPolicy)null);
        m = ApiConstants.REPLAY_POLICY_RE.matcher(json);
        this.replayPolicy = m.find() ? ConsumerConfiguration.GetOrDefault(ReplayPolicy.get(m.group(1))) : ConsumerConfiguration.GetOrDefault((ReplayPolicy)null);
        this.description = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE);
        this.durable = JsonUtils.readString(json, ApiConstants.DURABLE_NAME_RE);
        this.deliverSubject = JsonUtils.readString(json, ApiConstants.DELIVER_SUBJECT_RE);
        this.deliverGroup = JsonUtils.readString(json, ApiConstants.DELIVER_GROUP_RE);
        this.filterSubject = JsonUtils.readString(json, ApiConstants.FILTER_SUBJECT_RE);
        this.sampleFrequency = JsonUtils.readString(json, ApiConstants.SAMPLE_FREQ_RE);
        this.startTime = JsonUtils.readDate(json, ApiConstants.OPT_START_TIME_RE);
        this.ackWait = JsonUtils.readNanos(json, ApiConstants.ACK_WAIT_RE, (Duration)null);
        this.idleHeartbeat = JsonUtils.readNanos(json, ApiConstants.IDLE_HEARTBEAT_RE, (Duration)null);
        this.startSeq = JsonUtils.readLong(json, ApiConstants.OPT_START_SEQ_RE, CcNumeric.START_SEQ.initial());
        this.maxDeliver = JsonUtils.readLong(json, ApiConstants.MAX_DELIVER_RE, CcNumeric.MAX_DELIVER.initial());
        this.rateLimit = JsonUtils.readLong(json, ApiConstants.RATE_LIMIT_BPS_RE, CcNumeric.RATE_LIMIT.initial());
        this.maxAckPending = JsonUtils.readLong(json, ApiConstants.MAX_ACK_PENDING_RE, CcNumeric.MAX_ACK_PENDING.initial());
        this.maxPullWaiting = JsonUtils.readLong(json, ApiConstants.MAX_WAITING_RE, CcNumeric.MAX_PULL_WAITING.initial());
        this.flowControl = JsonUtils.readBoolean(json, ApiConstants.FLOW_CONTROL_RE);
        this.headersOnly = JsonUtils.readBoolean(json, ApiConstants.HEADERS_ONLY_RE);
    }

    private ConsumerConfiguration(Builder b) {
        this.deliverPolicy = b.deliverPolicy;
        this.ackPolicy = b.ackPolicy;
        this.replayPolicy = b.replayPolicy;
        this.description = b.description;
        this.durable = b.durable;
        this.startTime = b.startTime;
        this.ackWait = b.ackWait;
        this.filterSubject = b.filterSubject;
        this.sampleFrequency = b.sampleFrequency;
        this.deliverSubject = b.deliverSubject;
        this.deliverGroup = b.deliverGroup;
        this.idleHeartbeat = b.idleHeartbeat;
        this.flowControl = b.flowControl;
        this.headersOnly = b.headersOnly;
        this.startSeq = b.startSeq;
        this.maxDeliver = b.maxDeliver;
        this.rateLimit = b.rateLimit;
        this.maxAckPending = b.maxAckPending;
        this.maxPullWaiting = b.maxPullWaiting;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "durable_name", this.durable);
        JsonUtils.addField(sb, "deliver_subject", this.deliverSubject);
        JsonUtils.addField(sb, "deliver_group", this.deliverGroup);
        JsonUtils.addField(sb, "deliver_policy", ConsumerConfiguration.GetOrDefault(this.deliverPolicy).toString());
        JsonUtils.addField(sb, "opt_start_seq", this.startSeq);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "ack_policy", ConsumerConfiguration.GetOrDefault(this.ackPolicy).toString());
        JsonUtils.addFieldAsNanos(sb, "ack_wait", this.ackWait);
        JsonUtils.addField(sb, "max_deliver", this.maxDeliver);
        JsonUtils.addField(sb, "max_ack_pending", this.maxAckPending);
        JsonUtils.addField(sb, "filter_subject", this.filterSubject);
        JsonUtils.addField(sb, "replay_policy", ConsumerConfiguration.GetOrDefault(this.replayPolicy).toString());
        JsonUtils.addField(sb, "sample_freq", this.sampleFrequency);
        JsonUtils.addField(sb, "rate_limit_bps", this.rateLimit);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addFldWhenTrue(sb, "flow_control", this.flowControl);
        JsonUtils.addFldWhenTrue(sb, "headers_only", this.headersOnly);
        JsonUtils.addField(sb, "max_waiting", this.maxPullWaiting);
        return JsonUtils.endJson(sb).toString();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDurable() {
        return this.durable;
    }

    public String getDeliverSubject() {
        return this.deliverSubject;
    }

    public String getDeliverGroup() {
        return this.deliverGroup;
    }

    public DeliverPolicy getDeliverPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.deliverPolicy);
    }

    public long getStartSequence() {
        return CcNumeric.START_SEQ.valueOrInitial(this.startSeq);
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public AckPolicy getAckPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.ackPolicy);
    }

    public Duration getAckWait() {
        return this.ackWait;
    }

    public long getMaxDeliver() {
        return CcNumeric.MAX_DELIVER.valueOrInitial(this.maxDeliver);
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public ReplayPolicy getReplayPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.replayPolicy);
    }

    public long getRateLimit() {
        return CcNumeric.RATE_LIMIT.valueOrInitial(this.rateLimit);
    }

    public long getMaxAckPending() {
        return CcNumeric.MAX_ACK_PENDING.valueOrInitial(this.maxAckPending);
    }

    public String getSampleFrequency() {
        return this.sampleFrequency;
    }

    public Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public boolean isFlowControl() {
        return this.flowControl != null && this.flowControl != false;
    }

    public long getMaxPullWaiting() {
        return CcNumeric.MAX_PULL_WAITING.valueOrInitial(this.maxPullWaiting);
    }

    public boolean getHeadersOnly() {
        return this.headersOnly != null && this.headersOnly != false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConsumerConfiguration cc) {
        return cc == null ? new Builder() : new Builder(cc);
    }

    public String toString() {
        return "ConsumerConfiguration{description='" + this.description + '\'' + ", durable='" + this.durable + '\'' + ", deliverPolicy=" + (Object)((Object)this.deliverPolicy) + ", deliverSubject='" + this.deliverSubject + '\'' + ", deliverGroup='" + this.deliverGroup + '\'' + ", startSeq=" + this.startSeq + ", startTime=" + this.startTime + ", ackPolicy=" + (Object)((Object)this.ackPolicy) + ", ackWait=" + this.ackWait + ", maxDeliver=" + this.maxDeliver + ", filterSubject='" + this.filterSubject + '\'' + ", replayPolicy=" + (Object)((Object)this.replayPolicy) + ", sampleFrequency='" + this.sampleFrequency + '\'' + ", rateLimit=" + this.rateLimit + ", maxAckPending=" + this.maxAckPending + ", idleHeartbeat=" + this.idleHeartbeat + ", flowControl=" + this.flowControl + ", maxPullWaiting=" + this.maxPullWaiting + ", headersOnly=" + this.headersOnly + '}';
    }

    public static enum CcNumeric {
        START_SEQ(1L, -1L, -1L),
        MAX_DELIVER(1L, -1L, -1L),
        RATE_LIMIT(1L, -1L, -1L),
        MAX_ACK_PENDING(0L, 0L, 20000L),
        MAX_PULL_WAITING(0L, 0L, 512L);

        long min;
        long initial;
        long server;

        private CcNumeric(long min, long initial, long server) {
            this.min = min;
            this.initial = initial;
            this.server = server;
        }

        long initial() {
            return this.initial;
        }

        long valueOrInitial(Long val) {
            return val == null ? this.initial : val;
        }

        long initial(long val) {
            return val < this.min ? this.initial : val;
        }

        public long comparable(Long val) {
            return val == null || val < this.min || val == this.server ? this.initial : val;
        }

        public boolean wouldBeChange(Long user, Long srvr) {
            return user != null && this.comparable(user) != this.comparable(srvr);
        }
    }

    public static class Builder {
        private DeliverPolicy deliverPolicy;
        private AckPolicy ackPolicy;
        private ReplayPolicy replayPolicy;
        private String description;
        private String durable;
        private String deliverSubject;
        private String deliverGroup;
        private String filterSubject;
        private String sampleFrequency;
        private ZonedDateTime startTime;
        private Duration ackWait;
        private Duration idleHeartbeat;
        private Long startSeq;
        private Long maxDeliver;
        private Long rateLimit;
        private Long maxAckPending;
        private Long maxPullWaiting;
        private Boolean flowControl;
        private Boolean headersOnly;

        public Builder() {
        }

        public Builder(ConsumerConfiguration cc) {
            if (cc != null) {
                this.deliverPolicy = cc.deliverPolicy;
                this.ackPolicy = cc.ackPolicy;
                this.replayPolicy = cc.replayPolicy;
                this.description = cc.description;
                this.durable = cc.durable;
                this.deliverSubject = cc.deliverSubject;
                this.deliverGroup = cc.deliverGroup;
                this.filterSubject = cc.filterSubject;
                this.sampleFrequency = cc.sampleFrequency;
                this.startTime = cc.startTime;
                this.ackWait = cc.ackWait;
                this.idleHeartbeat = cc.idleHeartbeat;
                this.startSeq = cc.startSeq;
                this.maxDeliver = cc.maxDeliver;
                this.rateLimit = cc.rateLimit;
                this.maxAckPending = cc.maxAckPending;
                this.maxPullWaiting = cc.maxPullWaiting;
                this.flowControl = cc.flowControl;
                this.headersOnly = cc.headersOnly;
            }
        }

        public Builder description(String description) {
            this.description = Validator.emptyAsNull(description);
            return this;
        }

        public Builder durable(String durable) {
            this.durable = Validator.emptyAsNull(durable);
            return this;
        }

        public Builder deliverPolicy(DeliverPolicy policy) {
            this.deliverPolicy = policy;
            return this;
        }

        public Builder deliverSubject(String subject) {
            this.deliverSubject = Validator.emptyAsNull(subject);
            return this;
        }

        public Builder deliverGroup(String group) {
            this.deliverGroup = Validator.emptyAsNull(group);
            return this;
        }

        public Builder startSequence(Long sequence) {
            this.startSeq = sequence;
            return this;
        }

        public Builder startSequence(long sequence) {
            this.startSeq = sequence;
            return this;
        }

        public Builder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder ackPolicy(AckPolicy policy) {
            this.ackPolicy = policy;
            return this;
        }

        public Builder ackWait(Duration timeout) {
            this.ackWait = Validator.validateDurationNotRequiredNotLessThanMin(timeout, MIN_ACK_WAIT);
            return this;
        }

        public Builder ackWait(long timeoutMillis) {
            this.ackWait = Validator.validateDurationNotRequiredNotLessThanMin(timeoutMillis, MIN_ACK_WAIT);
            return this;
        }

        public Builder maxDeliver(Long maxDeliver) {
            this.maxDeliver = maxDeliver;
            return this;
        }

        public Builder maxDeliver(long maxDeliver) {
            this.maxDeliver = maxDeliver;
            return this;
        }

        public Builder filterSubject(String filterSubject) {
            this.filterSubject = Validator.emptyAsNull(filterSubject);
            return this;
        }

        public Builder replayPolicy(ReplayPolicy policy) {
            this.replayPolicy = policy;
            return this;
        }

        public Builder sampleFrequency(String frequency) {
            this.sampleFrequency = Validator.emptyAsNull(frequency);
            return this;
        }

        public Builder rateLimit(Long msgsPerSecond) {
            this.rateLimit = msgsPerSecond;
            return this;
        }

        public Builder rateLimit(long msgsPerSecond) {
            this.rateLimit = msgsPerSecond;
            return this;
        }

        public Builder maxAckPending(Long maxAckPending) {
            this.maxAckPending = maxAckPending;
            return this;
        }

        public Builder maxAckPending(long maxAckPending) {
            this.maxAckPending = maxAckPending;
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            this.idleHeartbeat = Validator.validateDurationNotRequiredNotLessThanMin(idleHeartbeat, MIN_IDLE_HEARTBEAT);
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            this.idleHeartbeat = Validator.validateDurationNotRequiredNotLessThanMin(idleHeartbeatMillis, MIN_IDLE_HEARTBEAT);
            return this;
        }

        public Builder flowControl(Duration idleHeartbeat) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeat);
        }

        public Builder flowControl(long idleHeartbeatMillis) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeatMillis);
        }

        public Builder maxPullWaiting(Long maxPullWaiting) {
            this.maxPullWaiting = maxPullWaiting;
            return this;
        }

        public Builder maxPullWaiting(long maxPullWaiting) {
            this.maxPullWaiting = maxPullWaiting;
            return this;
        }

        public Builder headersOnly(Boolean headersOnly) {
            this.headersOnly = headersOnly;
            return this;
        }

        public ConsumerConfiguration build() {
            return new ConsumerConfiguration(this);
        }

        public PushSubscribeOptions buildPushSubscribeOptions() {
            return ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(this.build())).build();
        }

        public PullSubscribeOptions buildPullSubscribeOptions() {
            return ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().configuration(this.build())).build();
        }
    }
}

