/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.ReconnectDelayHandler;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.ErrorListenerLoggerImpl;
import io.nats.client.impl.SocketDataPort;
import io.nats.client.support.NatsConstants;
import io.nats.client.support.SSLUtils;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;

public class Options {
    public static final String DEFAULT_URL = "nats://localhost:4222";
    public static final int DEFAULT_PORT = 4222;
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final Duration DEFAULT_RECONNECT_WAIT = Duration.ofMillis(2000L);
    public static final Duration DEFAULT_RECONNECT_JITTER = Duration.ofMillis(100L);
    public static final Duration DEFAULT_RECONNECT_JITTER_TLS = Duration.ofMillis(1000L);
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_PING_INTERVAL = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_REQUEST_CLEANUP_INTERVAL = Duration.ofSeconds(5L);
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final int DEFAULT_MAX_CONTROL_LINE = 4096;
    public static final String DEFAULT_DATA_PORT_TYPE = SocketDataPort.class.getCanonicalName();
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String DEFAULT_THREAD_NAME_PREFIX = "nats";
    public static final String DEFAULT_INBOX_PREFIX = "_INBOX.";
    public static final int MAX_MESSAGES_IN_NETWORK_BUFFER = 1000;
    public static final int DEFAULT_MAX_MESSAGES_IN_OUTGOING_QUEUE = 5000;
    public static final boolean DEFAULT_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = false;
    static final String PFX = "io.nats.client.";
    public static final String PROP_CONNECTION_CB = "io.nats.client.callback.connection";
    public static final String PROP_DATA_PORT_TYPE = "io.nats.client.dataport.type";
    public static final String PROP_ERROR_LISTENER = "io.nats.client.callback.error";
    public static final String PROP_MAX_PINGS = "io.nats.client.maxpings";
    public static final String PROP_PING_INTERVAL = "io.nats.client.pinginterval";
    public static final String PROP_CLEANUP_INTERVAL = "io.nats.client.cleanupinterval";
    public static final String PROP_CONNECTION_TIMEOUT = "io.nats.client.timeout";
    public static final String PROP_RECONNECT_BUF_SIZE = "io.nats.client.reconnect.buffer.size";
    public static final String PROP_RECONNECT_WAIT = "io.nats.client.reconnect.wait";
    public static final String PROP_MAX_RECONNECT = "io.nats.client.reconnect.max";
    public static final String PROP_RECONNECT_JITTER = "io.nats.client.reconnect.jitter";
    public static final String PROP_RECONNECT_JITTER_TLS = "io.nats.client.reconnect.jitter.tls";
    public static final String PROP_PEDANTIC = "io.nats.client.pedantic";
    public static final String PROP_VERBOSE = "io.nats.client.verbose";
    public static final String PROP_NO_ECHO = "io.nats.client.noecho";
    public static final String PROP_NO_HEADERS = "io.nats.client.noheaders";
    public static final String PROP_NO_NORESPONDERS = "io.nats.client.nonoresponders";
    public static final String PROP_CLIENT_SIDE_LIMIT_CHECKS = "io.nats.client.clientsidelimitchecks";
    public static final String PROP_CONNECTION_NAME = "io.nats.client.name";
    public static final String PROP_NORANDOMIZE = "io.nats.client.norandomize";
    public static final String PROP_SERVERS = "io.nats.client.servers";
    public static final String PROP_PASSWORD = "io.nats.client.password";
    public static final String PROP_USERNAME = "io.nats.client.username";
    public static final String PROP_TOKEN = "io.nats.client.token";
    public static final String PROP_URL = "io.nats.client.url";
    public static final String PROP_SECURE = "io.nats.client.secure";
    public static final String PROP_OPENTLS = "io.nats.client.opentls";
    public static final String PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE = "io.nats.client.outgoingqueue.maxmessages";
    public static final String PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = "io.nats.client.outgoingqueue.discardwhenfull";
    public static final String PROP_USE_OLD_REQUEST_STYLE = "use.old.request.style";
    public static final String PROP_MAX_CONTROL_LINE = "max.control.line";
    @Deprecated
    public static final String PROP_UTF8_SUBJECTS = "allow.utf8.subjects";
    public static final String PROP_INBOX_PREFIX = "inbox.prefix";
    static final String OPTION_VERBOSE = "verbose";
    static final String OPTION_PEDANTIC = "pedantic";
    static final String OPTION_TLS_REQUIRED = "tls_required";
    static final String OPTION_AUTH_TOKEN = "auth_token";
    static final String OPTION_USER = "user";
    static final String OPTION_PASSWORD = "pass";
    static final String OPTION_NAME = "name";
    static final String OPTION_LANG = "lang";
    static final String OPTION_VERSION = "version";
    static final String OPTION_PROTOCOL = "protocol";
    static final String OPTION_ECHO = "echo";
    static final String OPTION_NKEY = "nkey";
    static final String OPTION_SIG = "sig";
    static final String OPTION_JWT = "jwt";
    static final String OPTION_HEADERS = "headers";
    static final String OPTION_NORESPONDERS = "no_responders";
    private final List<URI> servers;
    private final boolean noRandomize;
    private final String connectionName;
    private final boolean verbose;
    private final boolean pedantic;
    private final SSLContext sslContext;
    private final int maxReconnect;
    private final int maxControlLine;
    private final Duration reconnectWait;
    private final Duration reconnectJitter;
    private final Duration reconnectJitterTls;
    private final Duration connectionTimeout;
    private final Duration pingInterval;
    private final Duration requestCleanupInterval;
    private final int maxPingsOut;
    private final long reconnectBufferSize;
    private final char[] username;
    private final char[] password;
    private final char[] token;
    private final String inboxPrefix;
    private boolean useOldRequestStyle;
    private final int bufferSize;
    private final boolean noEcho;
    private final boolean noHeaders;
    private final boolean noNoResponders;
    private final boolean clientSideLimitChecks;
    private final boolean utf8Support;
    private final int maxMessagesInOutgoingQueue;
    private final boolean discardMessagesWhenOutgoingQueueFull;
    private final AuthHandler authHandler;
    private final ReconnectDelayHandler reconnectDelayHandler;
    private final ErrorListener errorListener;
    private final ConnectionListener connectionListener;
    private final String dataPortType;
    private final boolean trackAdvancedStats;
    private final boolean traceConnection;
    private final ExecutorService executor;

    private Options(Builder b) {
        this.servers = b.servers;
        this.noRandomize = b.noRandomize;
        this.connectionName = b.connectionName;
        this.verbose = b.verbose;
        this.pedantic = b.pedantic;
        this.sslContext = b.sslContext;
        this.maxReconnect = b.maxReconnect;
        this.reconnectWait = b.reconnectWait;
        this.reconnectJitter = b.reconnectJitter;
        this.reconnectJitterTls = b.reconnectJitterTls;
        this.connectionTimeout = b.connectionTimeout;
        this.pingInterval = b.pingInterval;
        this.requestCleanupInterval = b.requestCleanupInterval;
        this.maxPingsOut = b.maxPingsOut;
        this.reconnectBufferSize = b.reconnectBufferSize;
        this.username = b.username;
        this.password = b.password;
        this.token = b.token;
        this.useOldRequestStyle = b.useOldRequestStyle;
        this.maxControlLine = b.maxControlLine;
        this.bufferSize = b.bufferSize;
        this.noEcho = b.noEcho;
        this.noHeaders = b.noHeaders;
        this.noNoResponders = b.noNoResponders;
        this.clientSideLimitChecks = b.clientSideLimitChecks;
        this.utf8Support = b.utf8Support;
        this.inboxPrefix = b.inboxPrefix;
        this.traceConnection = b.traceConnection;
        this.maxMessagesInOutgoingQueue = b.maxMessagesInOutgoingQueue;
        this.discardMessagesWhenOutgoingQueueFull = b.discardMessagesWhenOutgoingQueueFull;
        this.authHandler = b.authHandler;
        this.reconnectDelayHandler = b.reconnectDelayHandler;
        this.errorListener = b.errorListener == null ? new ErrorListenerLoggerImpl() : b.errorListener;
        this.connectionListener = b.connectionListener;
        this.dataPortType = b.dataPortType;
        this.trackAdvancedStats = b.trackAdvancedStats;
        this.executor = b.executor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public AuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public ReconnectDelayHandler getReconnectDelayHandler() {
        return this.reconnectDelayHandler;
    }

    public String getDataPortType() {
        return this.dataPortType;
    }

    public DataPort buildDataPort() {
        return (DataPort)Builder.createInstanceOf(this.dataPortType);
    }

    public Collection<URI> getServers() {
        return this.servers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    @Deprecated
    public boolean supportUTF8Subjects() {
        return this.utf8Support;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public boolean isNoHeaders() {
        return this.noHeaders;
    }

    public boolean isNoNoResponders() {
        return this.noNoResponders;
    }

    public boolean clientSideLimitChecks() {
        return this.clientSideLimitChecks;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public boolean isTrackAdvancedStats() {
        return this.trackAdvancedStats;
    }

    public boolean isTraceConnection() {
        return this.traceConnection;
    }

    public int getMaxControlLine() {
        return this.maxControlLine;
    }

    public boolean isTLSRequired() {
        return this.sslContext != null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public Duration getReconnectJitter() {
        return this.reconnectJitter;
    }

    public Duration getReconnectJitterTls() {
        return this.reconnectJitterTls;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public Duration getRequestCleanupInterval() {
        return this.requestCleanupInterval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Deprecated
    public String getUsername() {
        return this.username == null ? null : new String(this.username);
    }

    public char[] getUsernameChars() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password == null ? null : new String(this.password);
    }

    public char[] getPasswordChars() {
        return this.password;
    }

    @Deprecated
    public String getToken() {
        return this.token == null ? null : new String(this.token);
    }

    public char[] getTokenChars() {
        return this.token;
    }

    public boolean isOldRequestStyle() {
        return this.useOldRequestStyle;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public int getMaxMessagesInOutgoingQueue() {
        return this.maxMessagesInOutgoingQueue;
    }

    public boolean isDiscardMessagesWhenOutgoingQueueFull() {
        return this.discardMessagesWhenOutgoingQueueFull;
    }

    public URI createURIForServer(String serverURI) throws URISyntaxException {
        return Options.parseURIForServer(serverURI);
    }

    static URI parseURIForServer(String serverURI) throws URISyntaxException {
        URI uri;
        try {
            uri = new URI(serverURI);
            if (uri.getHost() == null || uri.getHost().length() == 0 || uri.getScheme() == null || uri.getScheme().length() == 0) {
                uri = new URI("nats://" + serverURI);
            }
        }
        catch (URISyntaxException e) {
            uri = new URI("nats://" + serverURI);
        }
        if (!NatsConstants.KNOWN_PROTOCOLS.contains(uri.getScheme())) {
            throw new URISyntaxException(serverURI, "unknown URI scheme ");
        }
        if (uri.getHost() != null && uri.getHost().length() > 0) {
            if (uri.getPort() == -1) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 4222, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        throw new URISyntaxException(serverURI, "unable to parse server URI");
    }

    public CharBuffer buildProtocolConnectOptionsString(String serverURI, boolean includeAuth, byte[] nonce) {
        CharBuffer connectString = CharBuffer.allocate(this.maxControlLine);
        connectString.append("{");
        this.appendOption(connectString, OPTION_LANG, "java", true, false);
        this.appendOption(connectString, OPTION_VERSION, Nats.CLIENT_VERSION, true, true);
        if (this.connectionName != null) {
            this.appendOption(connectString, OPTION_NAME, this.connectionName, true, true);
        }
        this.appendOption(connectString, OPTION_PROTOCOL, "1", false, true);
        this.appendOption(connectString, OPTION_VERBOSE, String.valueOf(this.isVerbose()), false, true);
        this.appendOption(connectString, OPTION_PEDANTIC, String.valueOf(this.isPedantic()), false, true);
        this.appendOption(connectString, OPTION_TLS_REQUIRED, String.valueOf(this.isTLSRequired()), false, true);
        this.appendOption(connectString, OPTION_ECHO, String.valueOf(!this.isNoEcho()), false, true);
        this.appendOption(connectString, OPTION_HEADERS, String.valueOf(!this.isNoHeaders()), false, true);
        this.appendOption(connectString, OPTION_NORESPONDERS, String.valueOf(!this.isNoNoResponders()), false, true);
        if (includeAuth && nonce != null && this.getAuthHandler() != null) {
            char[] nkey = this.getAuthHandler().getID();
            byte[] sig = this.getAuthHandler().sign(nonce);
            char[] jwt = this.getAuthHandler().getJWT();
            if (sig == null) {
                sig = new byte[]{};
            }
            if (jwt == null) {
                jwt = new char[]{};
            }
            if (nkey == null) {
                nkey = new char[]{};
            }
            String encodedSig = Base64.getUrlEncoder().withoutPadding().encodeToString(sig);
            this.appendOption(connectString, OPTION_NKEY, nkey, true, true);
            this.appendOption(connectString, OPTION_SIG, encodedSig, true, true);
            this.appendOption(connectString, OPTION_JWT, jwt, true, true);
        } else if (includeAuth) {
            String uriUser = null;
            String uriPass = null;
            String uriToken = null;
            try {
                URI uri = this.createURIForServer(serverURI);
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String[] info = userInfo.split(":");
                    if (info.length == 2) {
                        uriUser = info[0];
                        uriPass = info[1];
                    } else {
                        uriToken = userInfo;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uriUser != null) {
                this.appendOption(connectString, OPTION_USER, uriUser, true, true);
            } else if (this.username != null) {
                this.appendOption(connectString, OPTION_USER, this.username, true, true);
            }
            if (uriPass != null) {
                this.appendOption(connectString, OPTION_PASSWORD, uriPass, true, true);
            } else if (this.password != null) {
                this.appendOption(connectString, OPTION_PASSWORD, this.password, true, true);
            }
            if (uriToken != null) {
                this.appendOption(connectString, OPTION_AUTH_TOKEN, uriToken, true, true);
            } else if (this.token != null) {
                this.appendOption(connectString, OPTION_AUTH_TOKEN, this.token, true, true);
            }
        }
        connectString.append("}");
        connectString.flip();
        return connectString;
    }

    private void appendOption(CharBuffer builder, String key, String value, boolean quotes, boolean comma) {
        this._appendStart(builder, key, quotes, comma);
        builder.append(value);
        this._appendOptionEnd(builder, quotes);
    }

    private void appendOption(CharBuffer builder, String key, char[] value, boolean quotes, boolean comma) {
        this._appendStart(builder, key, quotes, comma);
        builder.put(value);
        this._appendOptionEnd(builder, quotes);
    }

    private void _appendStart(CharBuffer builder, String key, boolean quotes, boolean comma) {
        if (comma) {
            builder.append(',');
        }
        builder.append('\"');
        builder.append(key);
        builder.append('\"');
        builder.append(':');
        this._appendOptionEnd(builder, quotes);
    }

    private void _appendOptionEnd(CharBuffer builder, boolean quotes) {
        if (quotes) {
            builder.append('\"');
        }
    }

    public void setOldRequestStyle(boolean value) {
        this.useOldRequestStyle = value;
    }

    public static class Builder {
        private final ArrayList<URI> servers = new ArrayList();
        private boolean noRandomize = false;
        private String connectionName = null;
        private boolean verbose = false;
        private boolean pedantic = false;
        private SSLContext sslContext = null;
        private int maxControlLine = 4096;
        private int maxReconnect = 60;
        private Duration reconnectWait = DEFAULT_RECONNECT_WAIT;
        private Duration reconnectJitter = DEFAULT_RECONNECT_JITTER;
        private Duration reconnectJitterTls = DEFAULT_RECONNECT_JITTER_TLS;
        private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        private Duration pingInterval = DEFAULT_PING_INTERVAL;
        private Duration requestCleanupInterval = DEFAULT_REQUEST_CLEANUP_INTERVAL;
        private int maxPingsOut = 2;
        private long reconnectBufferSize = 0x800000L;
        private char[] username = null;
        private char[] password = null;
        private char[] token = null;
        private boolean useOldRequestStyle = false;
        private int bufferSize = 65536;
        private boolean trackAdvancedStats = false;
        private boolean traceConnection = false;
        private boolean noEcho = false;
        private boolean noHeaders = false;
        private boolean noNoResponders = false;
        private boolean clientSideLimitChecks = true;
        private boolean utf8Support = false;
        private String inboxPrefix = "_INBOX.";
        private int maxMessagesInOutgoingQueue = 5000;
        private boolean discardMessagesWhenOutgoingQueueFull = false;
        private AuthHandler authHandler;
        private ReconnectDelayHandler reconnectDelayHandler;
        private ErrorListener errorListener = null;
        private ConnectionListener connectionListener = null;
        private String dataPortType = DEFAULT_DATA_PORT_TYPE;
        private ExecutorService executor;

        public Builder() {
        }

        public Builder(Properties props) throws IllegalArgumentException {
            Object instance;
            boolean tls;
            boolean secure;
            if (props == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            if (props.containsKey(Options.PROP_URL)) {
                this.server(props.getProperty(Options.PROP_URL, Options.DEFAULT_URL));
            }
            if (props.containsKey(Options.PROP_USERNAME)) {
                this.username = props.getProperty(Options.PROP_USERNAME, null).toCharArray();
            }
            if (props.containsKey(Options.PROP_PASSWORD)) {
                this.password = props.getProperty(Options.PROP_PASSWORD, null).toCharArray();
            }
            if (props.containsKey(Options.PROP_TOKEN)) {
                this.token = props.getProperty(Options.PROP_TOKEN, null).toCharArray();
            }
            if (props.containsKey(Options.PROP_SERVERS)) {
                String str = props.getProperty(Options.PROP_SERVERS);
                if (str.isEmpty()) {
                    throw new IllegalArgumentException("io.nats.client.servers cannot be empty");
                }
                String[] servers = str.trim().split(",\\s*");
                this.servers(servers);
            }
            if (props.containsKey(Options.PROP_NORANDOMIZE)) {
                this.noRandomize = Boolean.parseBoolean(props.getProperty(Options.PROP_NORANDOMIZE));
            }
            if (props.containsKey(Options.PROP_SECURE) && (secure = Boolean.parseBoolean(props.getProperty(Options.PROP_SECURE)))) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    this.sslContext = null;
                    throw new IllegalArgumentException("Unable to retrieve default SSL context");
                }
            }
            if (props.containsKey(Options.PROP_OPENTLS) && (tls = Boolean.parseBoolean(props.getProperty(Options.PROP_OPENTLS)))) {
                try {
                    this.sslContext = SSLUtils.createOpenTLSContext();
                }
                catch (Exception e) {
                    this.sslContext = null;
                    throw new IllegalArgumentException("Unable to create open SSL context");
                }
            }
            if (props.containsKey(Options.PROP_CONNECTION_NAME)) {
                this.connectionName = props.getProperty(Options.PROP_CONNECTION_NAME, null);
            }
            if (props.containsKey(Options.PROP_VERBOSE)) {
                this.verbose = Boolean.parseBoolean(props.getProperty(Options.PROP_VERBOSE));
            }
            if (props.containsKey(Options.PROP_NO_ECHO)) {
                this.noEcho = Boolean.parseBoolean(props.getProperty(Options.PROP_NO_ECHO));
            }
            if (props.containsKey(Options.PROP_NO_HEADERS)) {
                this.noHeaders = Boolean.parseBoolean(props.getProperty(Options.PROP_NO_HEADERS));
            }
            if (props.containsKey(Options.PROP_NO_NORESPONDERS)) {
                this.noNoResponders = Boolean.parseBoolean(props.getProperty(Options.PROP_NO_NORESPONDERS));
            }
            if (props.containsKey(Options.PROP_CLIENT_SIDE_LIMIT_CHECKS)) {
                this.clientSideLimitChecks = Boolean.parseBoolean(props.getProperty(Options.PROP_CLIENT_SIDE_LIMIT_CHECKS));
            }
            if (props.containsKey(Options.PROP_UTF8_SUBJECTS)) {
                this.utf8Support = Boolean.parseBoolean(props.getProperty(Options.PROP_UTF8_SUBJECTS));
            }
            if (props.containsKey(Options.PROP_PEDANTIC)) {
                this.pedantic = Boolean.parseBoolean(props.getProperty(Options.PROP_PEDANTIC));
            }
            if (props.containsKey(Options.PROP_MAX_RECONNECT)) {
                this.maxReconnect = Integer.parseInt(props.getProperty(Options.PROP_MAX_RECONNECT, Integer.toString(60)));
            }
            if (props.containsKey(Options.PROP_RECONNECT_WAIT)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_RECONNECT_WAIT, "-1"));
                Duration duration = this.reconnectWait = ms < 0 ? DEFAULT_RECONNECT_WAIT : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_RECONNECT_JITTER)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_RECONNECT_JITTER, "-1"));
                Duration duration = this.reconnectJitter = ms < 0 ? DEFAULT_RECONNECT_JITTER : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_RECONNECT_JITTER_TLS)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_RECONNECT_JITTER_TLS, "-1"));
                Duration duration = this.reconnectJitterTls = ms < 0 ? DEFAULT_RECONNECT_JITTER_TLS : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_RECONNECT_BUF_SIZE)) {
                this.reconnectBufferSize = Long.parseLong(props.getProperty(Options.PROP_RECONNECT_BUF_SIZE, Long.toString(0x800000L)));
            }
            if (props.containsKey(Options.PROP_CONNECTION_TIMEOUT)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_CONNECTION_TIMEOUT, "-1"));
                Duration duration = this.connectionTimeout = ms < 0 ? DEFAULT_CONNECTION_TIMEOUT : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_MAX_CONTROL_LINE)) {
                int bytes = Integer.parseInt(props.getProperty(Options.PROP_MAX_CONTROL_LINE, "-1"));
                int n = this.maxControlLine = bytes < 0 ? 4096 : bytes;
            }
            if (props.containsKey(Options.PROP_PING_INTERVAL)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_PING_INTERVAL, "-1"));
                Duration duration = this.pingInterval = ms < 0 ? DEFAULT_PING_INTERVAL : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_CLEANUP_INTERVAL)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_CLEANUP_INTERVAL, "-1"));
                Duration duration = this.requestCleanupInterval = ms < 0 ? DEFAULT_REQUEST_CLEANUP_INTERVAL : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_MAX_PINGS)) {
                this.maxPingsOut = Integer.parseInt(props.getProperty(Options.PROP_MAX_PINGS, Integer.toString(2)));
            }
            if (props.containsKey(Options.PROP_USE_OLD_REQUEST_STYLE)) {
                this.useOldRequestStyle = Boolean.parseBoolean(props.getProperty(Options.PROP_USE_OLD_REQUEST_STYLE));
            }
            if (props.containsKey(Options.PROP_ERROR_LISTENER)) {
                instance = Builder.createInstanceOf(props.getProperty(Options.PROP_ERROR_LISTENER));
                this.errorListener = (ErrorListener)instance;
            }
            if (props.containsKey(Options.PROP_CONNECTION_CB)) {
                instance = Builder.createInstanceOf(props.getProperty(Options.PROP_CONNECTION_CB));
                this.connectionListener = (ConnectionListener)instance;
            }
            if (props.containsKey(Options.PROP_DATA_PORT_TYPE)) {
                this.dataPortType = props.getProperty(Options.PROP_DATA_PORT_TYPE);
            }
            if (props.containsKey(Options.PROP_INBOX_PREFIX)) {
                this.inboxPrefix(props.getProperty(Options.PROP_INBOX_PREFIX, Options.DEFAULT_INBOX_PREFIX));
            }
            if (props.containsKey(Options.PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE)) {
                int maxMessagesInOutgoingQueue = Integer.parseInt(props.getProperty(Options.PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE, "-1"));
                int n = this.maxMessagesInOutgoingQueue = maxMessagesInOutgoingQueue < 0 ? 5000 : maxMessagesInOutgoingQueue;
            }
            if (props.containsKey(Options.PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL)) {
                this.discardMessagesWhenOutgoingQueueFull = Boolean.parseBoolean(props.getProperty(Options.PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL, Boolean.toString(false)));
            }
        }

        static Object createInstanceOf(String className) {
            Object instance;
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return instance;
        }

        public Builder server(String serverURL) {
            return this.servers(serverURL.trim().split(","));
        }

        public Builder servers(String[] servers) {
            for (String s : servers) {
                if (s == null || s.isEmpty()) continue;
                try {
                    this.servers.add(Options.parseURIForServer(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Bad server URL: " + s, e);
                }
            }
            return this;
        }

        public Builder oldRequestStyle() {
            this.useOldRequestStyle = true;
            return this;
        }

        public Builder noRandomize() {
            this.noRandomize = true;
            return this;
        }

        public Builder noEcho() {
            this.noEcho = true;
            return this;
        }

        public Builder noHeaders() {
            this.noHeaders = true;
            return this;
        }

        public Builder noNoResponders() {
            this.noNoResponders = true;
            return this;
        }

        public Builder clientSideLimitChecks(boolean checks) {
            this.clientSideLimitChecks = checks;
            return this;
        }

        @Deprecated
        public Builder supportUTF8Subjects() {
            this.utf8Support = true;
            return this;
        }

        public Builder connectionName(String name) {
            this.connectionName = name;
            return this;
        }

        public Builder inboxPrefix(String prefix) {
            this.inboxPrefix = prefix;
            if (!this.inboxPrefix.endsWith(".")) {
                this.inboxPrefix = this.inboxPrefix + ".";
            }
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder pedantic() {
            this.pedantic = true;
            return this;
        }

        public Builder turnOnAdvancedStats() {
            this.trackAdvancedStats = true;
            return this;
        }

        public Builder traceConnection() {
            this.traceConnection = true;
            return this;
        }

        public Builder secure() throws NoSuchAlgorithmException, IllegalArgumentException {
            this.sslContext = SSLContext.getDefault();
            if (this.sslContext == null) {
                throw new IllegalArgumentException("No Default SSL Context");
            }
            return this;
        }

        public Builder opentls() throws NoSuchAlgorithmException {
            this.sslContext = SSLUtils.createOpenTLSContext();
            return this;
        }

        public Builder sslContext(SSLContext ctx) {
            this.sslContext = ctx;
            return this;
        }

        public Builder noReconnect() {
            this.maxReconnect = 0;
            return this;
        }

        public Builder maxReconnects(int max) {
            this.maxReconnect = max;
            return this;
        }

        public Builder reconnectWait(Duration time) {
            this.reconnectWait = time;
            return this;
        }

        public Builder reconnectJitter(Duration time) {
            this.reconnectJitter = time;
            return this;
        }

        public Builder reconnectJitterTls(Duration time) {
            this.reconnectJitterTls = time;
            return this;
        }

        public Builder maxControlLine(int bytes) {
            this.maxControlLine = bytes;
            return this;
        }

        public Builder connectionTimeout(Duration time) {
            this.connectionTimeout = time;
            return this;
        }

        public Builder pingInterval(Duration time) {
            this.pingInterval = time;
            return this;
        }

        public Builder requestCleanupInterval(Duration time) {
            this.requestCleanupInterval = time;
            return this;
        }

        public Builder maxPingsOut(int max) {
            this.maxPingsOut = max;
            return this;
        }

        public Builder bufferSize(int size) {
            this.bufferSize = size;
            return this;
        }

        public Builder reconnectBufferSize(long size) {
            this.reconnectBufferSize = size;
            return this;
        }

        public Builder userInfo(String userName, String password) {
            this.username = userName.toCharArray();
            this.password = password.toCharArray();
            return this;
        }

        public Builder userInfo(char[] userName, char[] password) {
            this.username = userName;
            this.password = password;
            return this;
        }

        @Deprecated
        public Builder token(String token) {
            this.token = token.toCharArray();
            return this;
        }

        public Builder token(char[] token) {
            this.token = token;
            return this;
        }

        public Builder authHandler(AuthHandler handler) {
            this.authHandler = handler;
            return this;
        }

        public Builder reconnectDelayHandler(ReconnectDelayHandler handler) {
            this.reconnectDelayHandler = handler;
            return this;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder dataPortType(String dataPortClassName) {
            this.dataPortType = dataPortClassName;
            return this;
        }

        public Builder maxMessagesInOutgoingQueue(int maxMessagesInOutgoingQueue) {
            this.maxMessagesInOutgoingQueue = maxMessagesInOutgoingQueue;
            return this;
        }

        public Builder discardMessagesWhenOutgoingQueueFull() {
            this.discardMessagesWhenOutgoingQueueFull = true;
            return this;
        }

        public Options build() throws IllegalStateException {
            if (this.username != null && this.token != null) {
                throw new IllegalStateException("Options can't have token and username");
            }
            if (this.servers.size() == 0) {
                this.server(Options.DEFAULT_URL);
            } else if (this.sslContext == null) {
                for (URI serverURI : this.servers) {
                    if ("tls".equals(serverURI.getScheme())) {
                        try {
                            this.sslContext = SSLContext.getDefault();
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new IllegalStateException("Unable to create default SSL context", e);
                        }
                    }
                    if (!"opentls".equals(serverURI.getScheme())) continue;
                    this.sslContext = SSLUtils.createOpenTLSContext();
                    break;
                }
            }
            if (this.executor == null) {
                String threadPrefix = this.connectionName != null && this.connectionName.length() > 0 ? this.connectionName : Options.DEFAULT_THREAD_NAME_PREFIX;
                this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 500L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(threadPrefix));
            }
            return new Options(this);
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        String name;
        AtomicInteger threadNo = new AtomicInteger(0);

        public DefaultThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = this.name + ":" + this.threadNo.incrementAndGet();
            Thread t = new Thread(r, threadName);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

