/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;

public class PurgeOptions
implements JsonSerializable {
    protected final String subject;
    protected final long seq;
    protected final long keep;

    private PurgeOptions(String subject, long seq, long keep) {
        this.subject = subject;
        this.seq = seq;
        this.keep = keep;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "filter", this.subject);
        JsonUtils.addField(sb, "seq", this.seq);
        JsonUtils.addField(sb, "keep", this.keep);
        return JsonUtils.endJson(sb).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurgeOptions options = (PurgeOptions)o;
        if (this.seq != options.seq) {
            return false;
        }
        if (this.keep != options.keep) {
            return false;
        }
        return this.subject != null ? this.subject.equals(options.subject) : options.subject == null;
    }

    public int hashCode() {
        int result = this.subject != null ? this.subject.hashCode() : 0;
        result = 31 * result + (int)(this.seq ^ this.seq >>> 32);
        result = 31 * result + (int)(this.keep ^ this.keep >>> 32);
        return result;
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSequence() {
        return this.seq;
    }

    public long getKeep() {
        return this.keep;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PurgeOptions subject(String subject) {
        return new Builder().subject(subject).build();
    }

    public static class Builder {
        private String subject;
        private long seq = -1L;
        private long keep = -1L;

        public Builder subject(String subject) {
            this.subject = Validator.validateSubject(subject, false);
            return this;
        }

        public Builder sequence(long seq) {
            this.seq = seq;
            return this;
        }

        public Builder keep(long keep) {
            this.keep = keep;
            return this;
        }

        public PurgeOptions build() {
            Validator.validateSubject(this.subject, false);
            if (this.seq > 0L && this.keep > 0L) {
                throw new IllegalArgumentException("seq and keep are mutually exclusive.");
            }
            return new PurgeOptions(this.subject, this.seq, this.keep);
        }
    }
}

