/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.SequencePair;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;

public class ConsumerInfo
extends ApiResponse<ConsumerInfo> {
    private final String stream;
    private final String name;
    private final ConsumerConfiguration configuration;
    private final ZonedDateTime created;
    private final SequencePair delivered;
    private final SequencePair ackFloor;
    private final long numPending;
    private final long numWaiting;
    private final long numAckPending;
    private final long numRedelivered;
    private final ClusterInfo clusterInfo;
    private final boolean pushBound;

    public ConsumerInfo(Message msg) {
        this(new String(msg.getData(), StandardCharsets.UTF_8));
    }

    public ConsumerInfo(String json) {
        super(json);
        this.stream = JsonUtils.readString(json, ApiConstants.STREAM_NAME_RE);
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.created = JsonUtils.readDate(json, ApiConstants.CREATED_RE);
        String jsonObject = JsonUtils.getJsonObject("config", json);
        this.configuration = new ConsumerConfiguration(jsonObject);
        jsonObject = JsonUtils.getJsonObject("delivered", json);
        this.delivered = new SequencePair(jsonObject);
        jsonObject = JsonUtils.getJsonObject("ack_floor", json);
        this.ackFloor = new SequencePair(jsonObject);
        this.numAckPending = JsonUtils.readLong(json, ApiConstants.NUM_ACK_PENDING_RE, 0L);
        this.numRedelivered = JsonUtils.readLong(json, ApiConstants.NUM_REDELIVERED_RE, 0L);
        this.numPending = JsonUtils.readLong(json, ApiConstants.NUM_PENDING_RE, 0L);
        this.numWaiting = JsonUtils.readLong(json, ApiConstants.NUM_WAITING_RE, 0L);
        this.clusterInfo = ClusterInfo.optionalInstance(json);
        this.pushBound = JsonUtils.readBoolean(json, ApiConstants.PUSH_BOUND_RE);
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public String getStreamName() {
        return this.stream;
    }

    public ZonedDateTime getCreationTime() {
        return this.created;
    }

    public SequencePair getDelivered() {
        return this.delivered;
    }

    public SequencePair getAckFloor() {
        return this.ackFloor;
    }

    public long getNumPending() {
        return this.numPending;
    }

    public long getNumWaiting() {
        return this.numWaiting;
    }

    public long getNumAckPending() {
        return this.numAckPending;
    }

    public long getRedelivered() {
        return this.numRedelivered;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public boolean isPushBound() {
        return this.pushBound;
    }

    public long getCalculatedPending() {
        return this.numPending + this.delivered.getConsumerSequence();
    }

    public String toString() {
        return "ConsumerInfo{stream='" + this.stream + '\'' + ", name='" + this.name + '\'' + ", numPending=" + this.numPending + ", numWaiting=" + this.numWaiting + ", numAckPending=" + this.numAckPending + ", numRedelivered=" + this.numRedelivered + ", pushBound=" + this.pushBound + ", created=" + this.created + ", " + JsonUtils.objectString("delivered", this.delivered) + ", " + JsonUtils.objectString("ackFloor", this.ackFloor) + ", " + JsonUtils.objectString("configuration", this.configuration) + ", " + JsonUtils.objectString("cluster", this.clusterInfo) + '}';
    }
}

