/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;

public class AccountLimits {
    private final long maxMemory;
    private final long maxStorage;
    private final long maxStreams;
    private final long maxConsumers;
    private final long maxAckPending;
    private final long memoryMaxStreamBytes;
    private final long storageMaxStreamBytes;
    private final boolean maxBytesRequired;

    AccountLimits(JsonValue vAccountLimits) {
        this.maxMemory = JsonValueUtils.readLong(vAccountLimits, "max_memory", 0L);
        this.maxStorage = JsonValueUtils.readLong(vAccountLimits, "max_storage", 0L);
        this.maxStreams = JsonValueUtils.readLong(vAccountLimits, "max_streams", 0L);
        this.maxConsumers = JsonValueUtils.readLong(vAccountLimits, "max_consumers", 0L);
        this.maxAckPending = JsonValueUtils.readLong(vAccountLimits, "max_ack_pending", 0L);
        this.memoryMaxStreamBytes = JsonValueUtils.readLong(vAccountLimits, "memory_max_stream_bytes", 0L);
        this.storageMaxStreamBytes = JsonValueUtils.readLong(vAccountLimits, "storage_max_stream_bytes", 0L);
        this.maxBytesRequired = JsonValueUtils.readBoolean(vAccountLimits, "max_bytes_required");
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxStorage() {
        return this.maxStorage;
    }

    public long getMaxStreams() {
        return this.maxStreams;
    }

    public long getMaxConsumers() {
        return this.maxConsumers;
    }

    public long getMaxAckPending() {
        return this.maxAckPending;
    }

    public long getMemoryMaxStreamBytes() {
        return this.memoryMaxStreamBytes;
    }

    public long getStorageMaxStreamBytes() {
        return this.storageMaxStreamBytes;
    }

    public boolean isMaxBytesRequired() {
        return this.maxBytesRequired;
    }
}

