/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.MirrorInfo;
import io.nats.client.api.SourceInfo;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamState;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;

public class StreamInfo
extends ApiResponse<StreamInfo> {
    private final ZonedDateTime created;
    private final StreamConfiguration config;
    private final StreamState state;
    private final ClusterInfo clusterInfo;
    private final MirrorInfo mirrorInfo;
    private final List<SourceInfo> sourceInfos;

    public StreamInfo(Message msg) {
        this(JsonParser.parseUnchecked(msg.getData()));
    }

    public StreamInfo(JsonValue vStreamInfo) {
        super(vStreamInfo);
        this.created = JsonValueUtils.readDate(this.jv, "created");
        this.config = StreamConfiguration.instance(JsonValueUtils.readValue(this.jv, "config"));
        this.state = new StreamState(JsonValueUtils.readValue(this.jv, "state"));
        this.clusterInfo = ClusterInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "cluster"));
        this.mirrorInfo = MirrorInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "mirror"));
        this.sourceInfos = SourceInfo.optionalListOf(JsonValueUtils.readValue(this.jv, "sources"));
    }

    public StreamConfiguration getConfiguration() {
        return this.config;
    }

    public StreamState getStreamState() {
        return this.state;
    }

    public ZonedDateTime getCreateTime() {
        return this.created;
    }

    public MirrorInfo getMirrorInfo() {
        return this.mirrorInfo;
    }

    public List<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }
}

