/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.IterableConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsMessageConsumer;
import java.io.IOException;
import java.time.Duration;

public class NatsIterableConsumer
extends NatsMessageConsumer
implements IterableConsumer {
    public NatsIterableConsumer(NatsConsumerContext.SubscriptionMaker subscriptionMaker, ConsumeOptions opts) throws IOException, JetStreamApiException {
        super(subscriptionMaker, null, opts);
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, JetStreamStatusCheckedException {
        try {
            return this.sub.nextMessage(timeout);
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
        catch (IllegalStateException i) {
            return null;
        }
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, JetStreamStatusCheckedException {
        return this.nextMessage(Duration.ofMillis(timeoutMillis));
    }
}

