/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.JetStreamApiException;
import io.nats.client.MessageHandler;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsMessageConsumerBase;
import io.nats.client.impl.TrackPendingListener;
import java.io.IOException;

class NatsMessageConsumer
extends NatsMessageConsumerBase
implements TrackPendingListener {
    protected final PullRequestOptions rePullPro;
    protected final int thresholdMessages;
    protected final long thresholdBytes;
    protected final NatsConsumerContext.SubscriptionMaker subscriptionMaker;

    NatsMessageConsumer(NatsConsumerContext.SubscriptionMaker subscriptionMaker, MessageHandler messageHandler, ConsumeOptions opts) throws IOException, JetStreamApiException {
        this.subscriptionMaker = subscriptionMaker;
        this.initSub(subscriptionMaker.makeSubscription(messageHandler));
        int bm = opts.getBatchSize();
        long bb = opts.getBatchBytes();
        int rePullMessages = Math.max(1, bm * opts.getThresholdPercent() / 100);
        long rePullBytes = bb == 0L ? 0L : Math.max(1L, bb * (long)opts.getThresholdPercent() / 100L);
        this.rePullPro = PullRequestOptions.builder(rePullMessages).maxBytes(rePullBytes).expiresIn(opts.getExpiresIn()).idleHeartbeat(opts.getIdleHeartbeat()).build();
        this.thresholdMessages = bm - rePullMessages;
        this.thresholdBytes = bb == 0L ? Integer.MIN_VALUE : bb - rePullBytes;
        this.sub._pull(PullRequestOptions.builder(bm).maxBytes(bb).expiresIn(opts.getExpiresIn()).idleHeartbeat(opts.getIdleHeartbeat()).build(), false, this);
    }

    @Override
    public void track(int pendingMessages, long pendingBytes, boolean trackingBytes) {
        if (!this.stopped && (this.pmm.pendingMessages <= this.thresholdMessages || this.pmm.trackingBytes && this.pmm.pendingBytes <= this.thresholdBytes)) {
            this.sub._pull(this.rePullPro, false, this);
        }
    }
}

