/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.MessageConsumer;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.PullMessageManager;
import java.io.IOException;
import java.time.Duration;

class NatsMessageConsumerBase
implements MessageConsumer {
    protected NatsJetStreamPullSubscription sub;
    protected PullMessageManager pmm;
    protected final Object subLock = new Object();
    protected boolean stopped;

    NatsMessageConsumerBase() {
    }

    protected void initSub(NatsJetStreamPullSubscription sub) {
        this.sub = sub;
        this.pmm = (PullMessageManager)sub.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        Object object = this.subLock;
        synchronized (object) {
            return this.sub.getConsumerInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long timeout) throws InterruptedException {
        Object object = this.subLock;
        synchronized (object) {
            if (!this.stopped) {
                try {
                    if (this.sub.getNatsDispatcher() != null) {
                        this.sub.getDispatcher().drain(Duration.ofMillis(timeout));
                    } else {
                        this.sub.drain(Duration.ofMillis(timeout));
                    }
                }
                finally {
                    this.stopped = true;
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (!this.stopped && this.sub.isActive()) {
                if (this.sub.getNatsDispatcher() != null) {
                    this.sub.getDispatcher().unsubscribe(this.sub);
                } else {
                    this.sub.unsubscribe();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

