/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.impl.Headers;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.TrackPendingListener;
import io.nats.client.support.Status;

class PullMessageManager
extends MessageManager {
    protected int pendingMessages = 0;
    protected long pendingBytes = 0L;
    protected boolean trackingBytes = false;
    protected boolean raiseStatusWarnings;
    protected TrackPendingListener trackPendingListener;

    protected PullMessageManager(NatsConnection conn, SubscribeOptions so, boolean syncMode) {
        super(conn, so, syncMode);
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        super.startup(sub);
        sub.setBeforeQueueProcessor(this::beforeQueueProcessorImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startPullRequest(String pullSubject, PullRequestOptions pro, boolean raiseStatusWarnings, TrackPendingListener trackPendingListener) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.raiseStatusWarnings = raiseStatusWarnings;
            this.trackPendingListener = trackPendingListener;
            this.pendingMessages += pro.getBatchSize();
            this.pendingBytes += pro.getMaxBytes();
            this.trackingBytes = this.pendingBytes > 0L;
            this.configureIdleHeartbeat(pro.getIdleHeartbeat(), -1L);
            if (this.hb) {
                this.initOrResetHeartbeatTimer();
            } else {
                this.shutdownHeartbeatTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackPending(int m, long b) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            boolean zero;
            this.pendingMessages -= m;
            boolean bl = zero = this.pendingMessages < 1;
            if (this.trackingBytes) {
                this.pendingBytes -= b;
                zero |= this.pendingBytes < 1L;
            }
            if (zero) {
                this.pendingMessages = 0;
                this.pendingBytes = 0L;
                this.trackingBytes = false;
                if (this.hb) {
                    this.shutdownHeartbeatTimer();
                }
            }
            if (this.trackPendingListener != null) {
                this.trackPendingListener.track(this.pendingMessages, this.pendingBytes, this.trackingBytes);
            }
        }
    }

    @Override
    protected Boolean beforeQueueProcessorImpl(NatsMessage msg) {
        String s;
        this.messageReceived();
        Status status = msg.getStatus();
        if (status == null) {
            this.trackPending(1, msg.consumeByteCount());
            return true;
        }
        if (status.isHeartbeat()) {
            return false;
        }
        Headers h = msg.getHeaders();
        if (h != null && (s = h.getFirst("Nats-Pending-Messages")) != null) {
            try {
                int m = Integer.parseInt(s);
                long b = Long.parseLong(h.getFirst("Nats-Pending-Bytes"));
                this.trackPending(m, b);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected MessageManager.ManageResult manage(Message msg) {
        Status status = msg.getStatus();
        if (status == null) {
            this.trackJsMessage(msg);
            return MessageManager.ManageResult.MESSAGE;
        }
        switch (status.getCode()) {
            case 404: 
            case 408: {
                if (this.raiseStatusWarnings) {
                    this.conn.executeCallback((c, el) -> el.pullStatusWarning(c, this.sub, status));
                }
                return MessageManager.ManageResult.STATUS_TERMINUS;
            }
            case 409: {
                String statMsg = status.getMessage();
                if (statMsg.startsWith("Exceeded Max")) {
                    if (this.raiseStatusWarnings) {
                        this.conn.executeCallback((c, el) -> el.pullStatusWarning(c, this.sub, status));
                    }
                    return MessageManager.ManageResult.STATUS_HANDLED;
                }
                if (!statMsg.equals(Status.BATCH_COMPLETED) && !statMsg.equals(Status.MESSAGE_SIZE_EXCEEDS_MAX_BYTES)) break;
                return MessageManager.ManageResult.STATUS_TERMINUS;
            }
        }
        this.conn.executeCallback((c, el) -> el.pullStatusError(c, this.sub, status));
        return MessageManager.ManageResult.STATUS_ERROR;
    }
}

