/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.service.Endpoint;
import io.nats.service.ServiceResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InfoResponse
extends ServiceResponse {
    public static final String TYPE = "io.nats.micro.v1.info_response";
    private final String description;
    private final List<Endpoint> endpoints;

    public InfoResponse(String id, String name, String version, Map<String, String> metadata, String description, List<Endpoint> endpoints) {
        super(TYPE, id, name, version, metadata);
        this.description = description;
        this.endpoints = endpoints;
    }

    public InfoResponse(byte[] jsonBytes) {
        this(InfoResponse.parseMessage(jsonBytes));
    }

    private InfoResponse(JsonValue jv) {
        super(TYPE, jv);
        this.description = JsonValueUtils.readString(jv, "description");
        this.endpoints = JsonValueUtils.read(jv, "endpoints", v -> JsonValueUtils.listOf(v, Endpoint::new));
    }

    @Override
    protected void subToJson(StringBuilder sb) {
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addJsons(sb, "endpoints", this.endpoints);
    }

    public String getDescription() {
        return this.description;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoResponse that = (InfoResponse)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        return JsonUtils.listEquals(this.endpoints, that.endpoints);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        return result;
    }
}

