/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.NUID;
import io.nats.client.ObjectStore;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.PurgeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.ObjectInfo;
import io.nats.client.api.ObjectLink;
import io.nats.client.api.ObjectMeta;
import io.nats.client.api.ObjectStoreStatus;
import io.nats.client.api.ObjectStoreWatchOption;
import io.nats.client.api.ObjectStoreWatcher;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsFeatureBase;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsObjectStoreWatchSubscription;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.Digester;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.NatsObjectStoreUtil;
import io.nats.client.support.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NatsObjectStore
extends NatsFeatureBase
implements ObjectStore {
    private final ObjectStoreOptions oso;
    private final String bucketName;
    private final String rawChunkPrefix;
    private final String pubSubChunkPrefix;
    private final String rawMetaPrefix;
    private final String pubSubMetaPrefix;

    NatsObjectStore(NatsConnection connection, String bucketName, ObjectStoreOptions oso) throws IOException {
        super(connection, oso);
        this.oso = oso;
        this.bucketName = Validator.validateBucketName(bucketName, true);
        this.streamName = NatsObjectStoreUtil.toStreamName(bucketName);
        this.rawChunkPrefix = NatsObjectStoreUtil.toChunkPrefix(bucketName);
        this.rawMetaPrefix = NatsObjectStoreUtil.toMetaPrefix(bucketName);
        if (oso == null) {
            this.pubSubChunkPrefix = this.rawChunkPrefix;
            this.pubSubMetaPrefix = this.rawMetaPrefix;
        } else if (oso.getJetStreamOptions().isDefaultPrefix()) {
            this.pubSubChunkPrefix = this.rawChunkPrefix;
            this.pubSubMetaPrefix = this.rawMetaPrefix;
        } else {
            this.pubSubChunkPrefix = oso.getJetStreamOptions().getPrefix() + this.rawChunkPrefix;
            this.pubSubMetaPrefix = oso.getJetStreamOptions().getPrefix() + this.rawMetaPrefix;
        }
    }

    String rawChunkSubject(String nuid) {
        return this.rawChunkPrefix + nuid;
    }

    String pubSubChunkSubject(String nuid) {
        return this.pubSubChunkPrefix + nuid;
    }

    String rawMetaSubject(String name) {
        return this.rawMetaPrefix + NatsObjectStoreUtil.encodeForSubject(name);
    }

    String rawAllMetaSubject() {
        return this.rawMetaPrefix + ">";
    }

    String pubSubMetaSubject(String name) {
        return this.pubSubMetaPrefix + NatsObjectStoreUtil.encodeForSubject(name);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    private ObjectInfo publishMeta(ObjectInfo info) throws JetStreamApiException, IOException {
        this.js.publish(NatsMessage.builder().subject(this.pubSubMetaSubject(info.getObjectName())).headers(NatsObjectStoreUtil.getMetaHeaders()).data(info.serialize()).build());
        return ObjectInfo.builder(info).modified(DateTimeUtils.gmtNow()).build();
    }

    @Override
    public ObjectInfo put(ObjectMeta meta, InputStream inputStream) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        Validator.validateNotNull(meta, "ObjectMeta");
        Validator.validateNotNull(meta.getObjectName(), "ObjectMeta name");
        Validator.validateNotNull(inputStream, "InputStream");
        if (meta.getObjectMetaOptions().getLink() != null) {
            throw NatsJetStreamClientError.OsLinkNotAllowOnPut.instance();
        }
        String nuid = NUID.nextGlobal();
        String chunkSubject = this.pubSubChunkSubject(nuid);
        int chunkSize = meta.getObjectMetaOptions().getChunkSize();
        if (chunkSize <= 0) {
            chunkSize = 131072;
        }
        try {
            Digester digester = new Digester();
            long totalSize = 0L;
            int chunks = 0;
            byte[] buffer = new byte[chunkSize];
            int red = chunkSize;
            while (red == chunkSize) {
                red = inputStream.read(buffer);
                if (red <= 0) continue;
                byte[] payload = red == chunkSize ? buffer : Arrays.copyOfRange(buffer, 0, red);
                digester.update(payload);
                this.js.publish(chunkSubject, payload);
                ++chunks;
                totalSize += (long)red;
            }
            ObjectInfo objectInfo = this.publishMeta(ObjectInfo.builder(this.bucketName, meta).size(totalSize).chunks(chunks).nuid(nuid).chunkSize(chunkSize).digest(digester.getDigestEntry()).build());
            return objectInfo;
        }
        catch (JetStreamApiException | IOException | NoSuchAlgorithmException e) {
            try {
                this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawChunkSubject(nuid)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ObjectInfo put(String objectName, InputStream inputStream) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(objectName), inputStream);
    }

    @Override
    public ObjectInfo put(String objectName, byte[] input) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(objectName), (InputStream)new ByteArrayInputStream(input));
    }

    @Override
    public ObjectInfo put(File file) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(file.getName()), Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    @Override
    public ObjectInfo get(String objectName, OutputStream out) throws IOException, JetStreamApiException, InterruptedException, NoSuchAlgorithmException {
        ObjectInfo oi = this.getInfo(objectName, false);
        if (oi == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (oi.isLink()) {
            ObjectLink link = oi.getLink();
            if (link.isBucketLink()) {
                throw NatsJetStreamClientError.OsGetLinkToBucket.instance();
            }
            if (link.getBucket().equals(this.bucketName)) {
                return this.get(link.getObjectName(), out);
            }
            return this.js.conn.objectStore(link.getBucket(), this.oso).get(link.getObjectName(), out);
        }
        Digester digester = new Digester();
        long totalBytes = 0L;
        long totalChunks = 0L;
        if (oi.getChunks() == 1L) {
            MessageInfo mi = this.jsm.getLastMessage(this.streamName, this.rawChunkSubject(oi.getNuid()));
            byte[] data = mi.getData();
            totalBytes = data.length;
            totalChunks = 1L;
            digester.update(data);
            out.write(data);
        } else {
            JetStreamSubscription sub = this.js.subscribe(this.pubSubChunkSubject(oi.getNuid()), ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().stream(this.streamName)).ordered(true).build());
            Message m = sub.nextMessage(Duration.ofSeconds(1L));
            while (m != null) {
                byte[] data = m.getData();
                totalBytes += (long)data.length;
                ++totalChunks;
                digester.update(data);
                out.write(data);
                m = sub.nextMessage(Duration.ofSeconds(1L));
            }
            sub.unsubscribe();
        }
        out.flush();
        if (totalBytes != oi.getSize()) {
            throw NatsJetStreamClientError.OsGetSizeMismatch.instance();
        }
        if (totalChunks != oi.getChunks()) {
            throw NatsJetStreamClientError.OsGetChunksMismatch.instance();
        }
        if (!digester.matches(oi.getDigest())) {
            throw NatsJetStreamClientError.OsGetDigestMismatch.instance();
        }
        return oi;
    }

    @Override
    public ObjectInfo getInfo(String objectName) throws IOException, JetStreamApiException {
        return this.getInfo(objectName, false);
    }

    @Override
    public ObjectInfo getInfo(String objectName, boolean includingDeleted) throws IOException, JetStreamApiException {
        MessageInfo mi = this._getLast(this.rawMetaSubject(objectName));
        if (mi == null) {
            return null;
        }
        ObjectInfo info = new ObjectInfo(mi);
        return includingDeleted || !info.isDeleted() ? info : null;
    }

    @Override
    public ObjectInfo updateMeta(String objectName, ObjectMeta meta) throws IOException, JetStreamApiException {
        boolean nameChange;
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(meta, "ObjectMeta");
        Validator.validateNotNull(meta.getObjectName(), "ObjectMeta name");
        ObjectInfo currentInfo = this.getInfo(objectName, true);
        if (currentInfo == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (currentInfo.isDeleted()) {
            throw NatsJetStreamClientError.OsObjectIsDeleted.instance();
        }
        boolean bl = nameChange = !objectName.equals(meta.getObjectName());
        if (nameChange && this.getInfo(meta.getObjectName(), false) != null) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        currentInfo = this.publishMeta(ObjectInfo.builder(currentInfo).objectName(meta.getObjectName()).description(meta.getDescription()).headers(meta.getHeaders()).build());
        if (nameChange) {
            this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawMetaSubject(objectName)));
        }
        return currentInfo;
    }

    @Override
    public ObjectInfo delete(String objectName) throws IOException, JetStreamApiException {
        ObjectInfo info = this.getInfo(objectName, true);
        if (info == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (info.isDeleted()) {
            return info;
        }
        ObjectInfo deleted = this.publishMeta(ObjectInfo.builder(info).deleted(true).size(0L).chunks(0L).digest(null).build());
        this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawChunkSubject(info.getNuid())));
        return deleted;
    }

    @Override
    public ObjectInfo addLink(String objectName, ObjectInfo toInfo) throws IOException, JetStreamApiException {
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(toInfo, "Link-To ObjectInfo");
        Validator.validateNotNull(toInfo.getObjectName(), "Link-To ObjectMeta");
        if (toInfo.isDeleted()) {
            throw NatsJetStreamClientError.OsObjectIsDeleted.instance();
        }
        if (toInfo.isLink()) {
            throw NatsJetStreamClientError.OsCantLinkToLink.instance();
        }
        ObjectInfo info = this.getInfo(objectName, false);
        if (info != null && !info.isLink()) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        return this.publishMeta(ObjectInfo.builder(this.bucketName, objectName).nuid(NUID.nextGlobal()).objectLink(toInfo.getBucket(), toInfo.getObjectName()).build());
    }

    @Override
    public ObjectInfo addBucketLink(String objectName, ObjectStore toStore) throws IOException, JetStreamApiException {
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(toStore, "Link-To ObjectStore");
        ObjectInfo info = this.getInfo(objectName, false);
        if (info != null && !info.isLink()) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        return this.publishMeta(ObjectInfo.builder(this.bucketName, objectName).nuid(NUID.nextGlobal()).bucketLink(toStore.getBucketName()).build());
    }

    @Override
    public ObjectStoreStatus seal() throws IOException, JetStreamApiException {
        StreamInfo si = this.jsm.getStreamInfo(this.streamName);
        si = this.jsm.updateStream(StreamConfiguration.builder(si.getConfiguration()).seal().build());
        return new ObjectStoreStatus(si);
    }

    @Override
    public List<ObjectInfo> getList() throws IOException, JetStreamApiException, InterruptedException {
        ArrayList<ObjectInfo> list = new ArrayList<ObjectInfo>();
        this.visitSubject(this.rawAllMetaSubject(), DeliverPolicy.LastPerSubject, false, true, m -> {
            ObjectInfo oi = new ObjectInfo(m);
            if (!oi.isDeleted()) {
                list.add(oi);
            }
        });
        return list;
    }

    @Override
    public NatsObjectStoreWatchSubscription watch(ObjectStoreWatcher watcher, ObjectStoreWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        return new NatsObjectStoreWatchSubscription(this, watcher, watchOptions);
    }

    @Override
    public ObjectStoreStatus getStatus() throws IOException, JetStreamApiException {
        return new ObjectStoreStatus(this.jsm.getStreamInfo(this.streamName));
    }
}

