/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.ArrayList;
import java.util.List;

public class Subject
implements Comparable<Subject> {
    private final String name;
    private final long count;

    static List<Subject> listOf(JsonValue vSubjects) {
        ArrayList<Subject> list = new ArrayList<Subject>();
        if (vSubjects != null && vSubjects.map != null) {
            for (String subject : vSubjects.map.keySet()) {
                Long count = JsonValueUtils.getLong(vSubjects.map.get(subject));
                if (count == null) continue;
                list.add(new Subject(subject, count));
            }
        }
        return list;
    }

    private Subject(String name, long count) {
        this.name = name;
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return "Subject{name='" + this.name + '\'' + ", count=" + this.count + '}';
    }

    @Override
    public int compareTo(Subject o) {
        return this.name.compareTo(o.name);
    }
}

