/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.impl.ListRequestEngine;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.List;

abstract class AbstractListReader {
    private final String objectName;
    private final String filterFieldName;
    protected ListRequestEngine engine;

    void process(Message msg) throws JetStreamApiException {
        this.engine = new ListRequestEngine(msg);
        this.processItems(JsonValueUtils.readArray(this.engine.getJv(), this.objectName));
    }

    abstract void processItems(List<JsonValue> var1);

    AbstractListReader(String objectName) {
        this(objectName, null);
    }

    AbstractListReader(String objectName, String filterFieldName) {
        this.objectName = objectName;
        this.filterFieldName = filterFieldName;
        this.engine = new ListRequestEngine();
    }

    byte[] nextJson() {
        return this.engine.internalNextJson();
    }

    byte[] nextJson(String filter) {
        if (this.filterFieldName == null) {
            throw new IllegalArgumentException("Filter not supported.");
        }
        return this.engine.internalNextJson(this.filterFieldName, filter);
    }

    boolean hasMore() {
        return this.engine.hasMore();
    }
}

