/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.IterableConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.Message;
import io.nats.client.MessageConsumer;
import io.nats.client.MessageHandler;
import io.nats.client.PullRequestOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.OrderedConsumerConfiguration;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsFetchConsumer;
import io.nats.client.impl.NatsIterableConsumer;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsMessageConsumer;
import io.nats.client.impl.NatsMessageConsumerBase;
import io.nats.client.impl.NatsStreamContext;
import io.nats.client.impl.PullMessageManager;
import io.nats.client.impl.SimplifiedSubscriptionMaker;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;

public class NatsConsumerContext
implements ConsumerContext,
SimplifiedSubscriptionMaker {
    private final Object stateLock = new Object();
    private final NatsStreamContext streamCtx;
    private final boolean ordered;
    private final ConsumerConfiguration originalOrderedCc;
    private final String subscribeSubject;
    private final PullSubscribeOptions unorderedBindPso;
    private ConsumerInfo cachedConsumerInfo;
    private String consumerName;
    private NatsMessageConsumerBase lastConsumer;
    private long highestSeq;
    private Dispatcher defaultDispatcher;

    NatsConsumerContext(NatsStreamContext sc, ConsumerInfo ci) {
        this.streamCtx = sc;
        this.ordered = false;
        this.originalOrderedCc = null;
        this.subscribeSubject = null;
        this.consumerName = ci.getName();
        this.unorderedBindPso = PullSubscribeOptions.fastBind(sc.streamName, this.consumerName);
        this.cachedConsumerInfo = ci;
    }

    NatsConsumerContext(NatsStreamContext sc, OrderedConsumerConfiguration config) {
        this.streamCtx = sc;
        this.ordered = true;
        this.originalOrderedCc = ConsumerConfiguration.builder().filterSubjects(config.getFilterSubjects()).deliverPolicy(config.getDeliverPolicy()).startSequence(config.getStartSequence()).startTime(config.getStartTime()).replayPolicy(config.getReplayPolicy()).headersOnly(config.getHeadersOnly()).build();
        this.subscribeSubject = Validator.validateSubject(this.originalOrderedCc.getFilterSubject(), false);
        this.unorderedBindPso = null;
    }

    @Override
    public NatsJetStreamPullSubscription subscribe(MessageHandler messageHandler, Dispatcher userDispatcher, PullMessageManager optionalPmm, Long optionalInactiveThreshold) throws IOException, JetStreamApiException {
        PullSubscribeOptions pso;
        if (this.ordered) {
            if (this.lastConsumer != null) {
                this.highestSeq = Math.max(this.highestSeq, this.lastConsumer.pmm.lastStreamSeq);
            }
            ConsumerConfiguration cc = this.streamCtx.js.consumerConfigurationForOrdered(this.originalOrderedCc, this.highestSeq, null, null, optionalInactiveThreshold);
            pso = new OrderedPullSubscribeOptionsBuilder(this.streamCtx.streamName, cc).build();
        } else {
            pso = this.unorderedBindPso;
        }
        if (messageHandler == null) {
            return (NatsJetStreamPullSubscription)this.streamCtx.js.createSubscription(this.subscribeSubject, null, pso, null, null, null, false, optionalPmm);
        }
        Dispatcher d = userDispatcher;
        if (d == null) {
            if (this.defaultDispatcher == null) {
                this.defaultDispatcher = this.streamCtx.js.conn.createDispatcher();
            }
            d = this.defaultDispatcher;
        }
        return (NatsJetStreamPullSubscription)this.streamCtx.js.createSubscription(this.subscribeSubject, null, pso, null, (NatsDispatcher)d, messageHandler, false, optionalPmm);
    }

    private void checkState() throws IOException {
        if (this.lastConsumer != null) {
            if (this.ordered && !this.lastConsumer.finished.get()) {
                throw new IOException("The ordered consumer is already receiving messages. Ordered Consumer does not allow multiple instances at time.");
            }
            if (this.lastConsumer.finished.get() && !this.lastConsumer.stopped.get()) {
                this.lastConsumer.lenientClose();
            }
        }
    }

    private NatsMessageConsumerBase trackConsume(NatsMessageConsumerBase con) {
        this.lastConsumer = con;
        return con;
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        this.cachedConsumerInfo = this.streamCtx.jsm.getConsumerInfo(this.streamCtx.streamName, this.consumerName);
        this.consumerName = this.cachedConsumerInfo.getName();
        return this.cachedConsumerInfo;
    }

    @Override
    public ConsumerInfo getCachedConsumerInfo() {
        return this.cachedConsumerInfo;
    }

    @Override
    public Message next() throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        return this.next(30000L);
    }

    @Override
    public Message next(Duration maxWait) throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        return maxWait == null ? this.next(30000L) : this.next(maxWait.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message next(long maxWaitMillis) throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        if (maxWaitMillis < 1000L) {
            throw new IllegalArgumentException("Max wait must be at least 1000 milliseconds.");
        }
        NatsMessageConsumerBase nmcb = null;
        Object object = this.stateLock;
        synchronized (object) {
            this.checkState();
            try {
                long inactiveThreshold = maxWaitMillis * 110L / 100L;
                nmcb = new NatsMessageConsumerBase(this.cachedConsumerInfo);
                nmcb.initSub(this.subscribe(null, null, null, inactiveThreshold));
                nmcb.sub._pull(PullRequestOptions.builder(1).expiresIn(maxWaitMillis - 10L).build(), false, null);
                this.trackConsume(nmcb);
            }
            catch (Exception e) {
                if (nmcb != null) {
                    try {
                        nmcb.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        try {
            object = nmcb.sub.nextMessage(maxWaitMillis);
            return object;
        }
        finally {
            try {
                nmcb.finished.set(true);
                nmcb.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FetchConsumer fetchMessages(int maxMessages) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxMessages(maxMessages).build());
    }

    @Override
    public FetchConsumer fetchBytes(int maxBytes) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxBytes(maxBytes).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConsumer fetch(FetchConsumeOptions fetchConsumeOptions) throws IOException, JetStreamApiException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkState();
            Validator.required(fetchConsumeOptions, "Fetch Consume Options");
            return (FetchConsumer)((Object)this.trackConsume(new NatsFetchConsumer(this, this.cachedConsumerInfo, fetchConsumeOptions)));
        }
    }

    @Override
    public IterableConsumer iterate() throws IOException, JetStreamApiException {
        return this.iterate(ConsumeOptions.DEFAULT_CONSUME_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterableConsumer iterate(ConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkState();
            Validator.required(consumeOptions, "Consume Options");
            return (IterableConsumer)((Object)this.trackConsume(new NatsIterableConsumer(this, this.cachedConsumerInfo, consumeOptions)));
        }
    }

    @Override
    public MessageConsumer consume(MessageHandler handler) throws IOException, JetStreamApiException {
        return this.consume(ConsumeOptions.DEFAULT_CONSUME_OPTIONS, null, handler);
    }

    @Override
    public MessageConsumer consume(Dispatcher dispatcher, MessageHandler handler) throws IOException, JetStreamApiException {
        return this.consume(ConsumeOptions.DEFAULT_CONSUME_OPTIONS, dispatcher, handler);
    }

    @Override
    public MessageConsumer consume(ConsumeOptions consumeOptions, MessageHandler handler) throws IOException, JetStreamApiException {
        return this.consume(consumeOptions, null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageConsumer consume(ConsumeOptions consumeOptions, Dispatcher userDispatcher, MessageHandler handler) throws IOException, JetStreamApiException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkState();
            Validator.required(handler, "Message Handler");
            Validator.required(consumeOptions, "Consume Options");
            return this.trackConsume(new NatsMessageConsumer(this, this.cachedConsumerInfo, consumeOptions, userDispatcher, handler));
        }
    }

    static class OrderedPullSubscribeOptionsBuilder
    extends PullSubscribeOptions.Builder {
        OrderedPullSubscribeOptionsBuilder(String streamName, ConsumerConfiguration cc) {
            this.stream(streamName);
            this.configuration(cc);
            this.ordered = true;
        }
    }
}

